/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logauth.listener;

import de.tofastforyou.logauth.LogAuth;
import de.tofastforyou.logauth.api.UserManagementAPI;
import de.tofastforyou.logauth.files.LanguageFile;
import de.tofastforyou.logauth.logcaptcha.LogCaptchaIntegration;
import de.tofastforyou.logauth.util.Countdown;
import de.tofastforyou.logauth.util.Vars;
import de.tofastforyou.logauth.util.inventories.PINLoginMenuGUI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class JoinListener
implements Listener {
    private static final long DELAYED_MESSAGE_TICKS = 60L;
    private static final long REMINDER_INTERVAL_TICKS = 80L;
    private static final long LOGIN_REMINDER_DELAY_WITHOUT_CAPTCHA = 40L;

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.isPlayerAlreadyLoggedIn(player)) {
            this.sendAlreadyLoggedInMessage(player);
            return;
        }
        this.addPlayerToLogoutList(player);
        this.handlePlayerTeleportation(player);
        this.startCountdown(player);
        if (this.usePIN()) {
            PINLoginMenuGUI.getInstance().openGUI(player);
        } else {
            this.scheduleReminderMessages(player);
        }
    }

    private boolean isPlayerAlreadyLoggedIn(Player player) {
        return LogAuth.getLogAuth().getConfig().getBoolean("logAuth.Options.SavePlayersWhoLoggedIn") && UserManagementAPI.getUserManagementAPI().hasPlayerLoggedIn(player.getName());
    }

    private boolean usePIN() {
        return LogAuth.getLogAuth().getConfig().getBoolean("logAuth.Options.UsePINInsteadOfPassword");
    }

    private void sendAlreadyLoggedInMessage(Player player) {
        String message = this.getLocalizedMessage("ExistingInLoggedInList");
        player.sendMessage(this.formatMessage(message));
    }

    private void addPlayerToLogoutList(Player player) {
        Vars.getVars().logOut.add(player);
    }

    private void handlePlayerTeleportation(Player player) {
        if (!this.shouldTeleportNotLoggedInPlayers()) {
            return;
        }
        if (UserManagementAPI.getUserManagementAPI().isNotLoggedInSpawnLocationSet()) {
            this.teleportPlayerToNotLoggedInLocation(player);
        } else {
            this.scheduleNotLoggedInSpawnNotSetMessage(player);
        }
    }

    private boolean shouldTeleportNotLoggedInPlayers() {
        return LogAuth.getLogAuth().getConfig().getBoolean("logAuth.Options.TeleportNotLoggedInPlayers");
    }

    private void teleportPlayerToNotLoggedInLocation(Player player) {
        UserManagementAPI.getUserManagementAPI().saveLocationTemporarily(player.getLocation(), player.getName());
        UserManagementAPI.getUserManagementAPI().teleportPlayerToNotLoggedInLocation(player);
    }

    private void scheduleNotLoggedInSpawnNotSetMessage(final Player player) {
        long delay = this.isLogCaptchaInstalled() ? (long)LogCaptchaIntegration.getLogCaptchaIntegration().getWaitingTimeFromLogCaptcha() + 60L : 60L;
        new BukkitRunnable(){

            public void run() {
                String message = JoinListener.this.getLocalizedMessage("NotLoggedInSpawnNotSet");
                player.sendMessage(JoinListener.this.formatMessage(message));
            }
        }.runTaskLater((Plugin)LogAuth.getLogAuth(), delay);
    }

    private void startCountdown(Player player) {
        Countdown.getCountdown().startCountdown(player);
    }

    private void scheduleReminderMessages(Player player) {
        long delay = this.calculateReminderDelay();
        Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)LogAuth.getLogAuth(), (Runnable)new ReminderTask(player), delay, 80L);
    }

    private long calculateReminderDelay() {
        return this.isLogCaptchaInstalled() ? (long)LogCaptchaIntegration.getLogCaptchaIntegration().getWaitingTimeFromLogCaptcha() + 60L : 40L;
    }

    private boolean isLogCaptchaInstalled() {
        return LogCaptchaIntegration.getLogCaptchaIntegration().isLogCaptchaInstalled();
    }

    private String getLocalizedMessage(String messageKey) {
        String currentLanguage = Vars.getVars().currentLanguage;
        return LanguageFile.getInstance().getLanguageConfig().getString(currentLanguage + ".Messages." + messageKey);
    }

    private String formatMessage(String message) {
        return Vars.getVars().pr + ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private class ReminderTask
    implements Runnable {
        private final Player player;

        public ReminderTask(Player player) {
            this.player = player;
        }

        @Override
        public void run() {
            if (!Vars.getVars().logOut.contains(this.player)) {
                return;
            }
            String messageKey = UserManagementAPI.getUserManagementAPI().isUserRegistererd(this.player.getName()) ? "LoginReminder" : "RegisterReminder";
            String message = JoinListener.this.getLocalizedMessage(messageKey);
            this.player.sendMessage(JoinListener.this.formatMessage(message));
        }
    }
}

