/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logauth.commands;

import de.tofastforyou.logauth.LogAuth;
import de.tofastforyou.logauth.api.UserManagementAPI;
import de.tofastforyou.logauth.files.LanguageFile;
import de.tofastforyou.logauth.util.Vars;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetNotLoggedInSpawnCommand
implements CommandExecutor {
    private static final String COMMAND_NAME = "setnotloggedinspawn";
    private static final String SUCCESS_MESSAGE = String.valueOf(ChatColor.GRAY) + "You " + String.valueOf(ChatColor.GREEN) + "successfully " + String.valueOf(ChatColor.GRAY) + "saved the " + String.valueOf(ChatColor.YELLOW) + "NotLoggedInSpawn " + String.valueOf(ChatColor.GRAY) + "location!";

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!this.isValidCommand(cmd)) {
            return false;
        }
        if (!this.isPlayer(sender)) {
            return false;
        }
        Player player = (Player)sender;
        if (!this.hasRequiredPermission(player)) {
            this.sendNoPermissionMessage(player);
            return false;
        }
        if (this.hasInvalidArguments(args)) {
            this.sendUsageMessage(player);
            return false;
        }
        this.setNotLoggedInSpawn(player);
        return true;
    }

    private boolean isValidCommand(Command cmd) {
        return cmd.getName().equalsIgnoreCase(COMMAND_NAME);
    }

    private boolean isPlayer(CommandSender sender) {
        return sender instanceof Player;
    }

    private boolean hasRequiredPermission(Player player) {
        String permission = LogAuth.getLogAuth().getConfig().getString("logAuth.Permissions.logAdmin");
        return player.hasPermission(permission);
    }

    private boolean hasInvalidArguments(String[] args) {
        return args.length > 0;
    }

    private void sendNoPermissionMessage(Player player) {
        String message = this.buildLanguageMessage("Messages.NoPermission");
        player.sendMessage(message);
    }

    private void sendUsageMessage(Player player) {
        String message = this.buildLanguageMessage("Messages.SetNotLoggedInSpawnCommandUsage");
        player.sendMessage(message);
    }

    private String buildLanguageMessage(String messageKey) {
        String prefix = Vars.getVars().pr;
        String language = Vars.getVars().currentLanguage;
        String fullKey = language + "." + messageKey;
        String rawMessage = LanguageFile.getInstance().getLanguageConfig().getString(fullKey);
        String coloredMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)rawMessage);
        return prefix + coloredMessage;
    }

    private void setNotLoggedInSpawn(Player player) {
        UserManagementAPI.getUserManagementAPI().createNotLoggedInSpawn(player.getLocation());
        player.sendMessage(Vars.getVars().pr + SUCCESS_MESSAGE);
    }
}

