/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logauth.commands;

import de.tofastforyou.logauth.LogAuth;
import de.tofastforyou.logauth.api.UserManagementAPI;
import de.tofastforyou.logauth.files.LanguageFile;
import de.tofastforyou.logauth.util.ErrorSaver;
import de.tofastforyou.logauth.util.ErrorTypes;
import de.tofastforyou.logauth.util.LogAuthLogger;
import de.tofastforyou.logauth.util.Vars;
import java.util.concurrent.TimeUnit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ResetUserCommand
implements CommandExecutor {
    private static final String COMMAND_NAME = "adminreset";
    private static final int SLEEP_DURATION_SECONDS = 1;
    private final boolean IS_PIN_ENABLED = LogAuth.getLogAuth().getConfig().getBoolean("logAuth.Options.UsePINInsteadOfPassword");

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!this.isValidCommand(cmd, sender)) {
            return false;
        }
        if (this.IS_PIN_ENABLED) {
            this.sendMessage((Player)sender, "PINIsEnabled");
            return true;
        }
        Player player = (Player)sender;
        if (!this.isValidArgumentCount(args)) {
            this.sendUsageMessage(player);
            return false;
        }
        return this.handleResetCommand(player, args[0]);
    }

    private boolean isValidCommand(Command cmd, CommandSender sender) {
        return cmd.getName().equalsIgnoreCase(COMMAND_NAME) && sender instanceof Player;
    }

    private boolean isValidArgumentCount(String[] args) {
        return args.length == 1;
    }

    private void sendUsageMessage(Player player) {
        String message = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocalizedMessage("ResetCommandUsage"));
        player.sendMessage(message);
    }

    private boolean handleResetCommand(Player player, String backupCode) {
        if (!this.isBackupCodeValid(player.getName(), backupCode)) {
            this.sendIncorrectBackupCodeMessage(player);
            return true;
        }
        this.resetPlayerPassword(player);
        return true;
    }

    private boolean isBackupCodeValid(String playerName, String backupCode) {
        return UserManagementAPI.getUserManagementAPI().isBackupCodeEqual(playerName, backupCode);
    }

    private void sendIncorrectBackupCodeMessage(Player player) {
        String message = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocalizedMessage("BackupCodeIncorrect"));
        player.sendMessage(message);
    }

    private void resetPlayerPassword(Player player) {
        String playerName = player.getName();
        UserManagementAPI.getUserManagementAPI().resetUser(playerName);
        this.sendPasswordResetMessage(player);
        this.sleepThread();
        this.logPasswordReset(playerName);
        this.kickPlayerWithMessage(player);
    }

    private void sendPasswordResetMessage(Player player) {
        String message = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocalizedMessage("PasswordReset"));
        player.sendMessage(message);
    }

    private void sleepThread() {
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException e) {
            this.handleSleepInterruption();
        }
    }

    private void handleSleepInterruption() {
        ErrorSaver.getErrorSaver().saveError(ErrorTypes.UNKNOWN_ERROR, this.toString(), "Could not sleep thread in reset command!");
    }

    private void logPasswordReset(String playerName) {
        LogAuthLogger.getLogAuthLogger().log(playerName + " reset their password!");
    }

    private void kickPlayerWithMessage(Player player) {
        String kickMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocalizedMessage("Messages.ResetKickMessage"));
        player.kickPlayer(kickMessage);
    }

    private void sendMessage(Player player, String messageKey) {
        String message = this.getLocalizedMessage(messageKey);
        player.sendMessage(Vars.getVars().pr + ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }

    private String getLocalizedMessage(String messageKey) {
        String path = Vars.getVars().currentLanguage + ".Messages." + messageKey;
        return LanguageFile.getInstance().getLanguageConfig().getString(path, "Message not found: " + messageKey);
    }
}

