/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logauth.commands;

import de.tofastforyou.logauth.LogAuth;
import de.tofastforyou.logauth.api.UserManagementAPI;
import de.tofastforyou.logauth.files.LanguageFile;
import de.tofastforyou.logauth.util.LogAuthLogger;
import de.tofastforyou.logauth.util.Vars;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RegisterCommand
implements CommandExecutor {
    private static final String COMMAND_NAME = "register";
    private final LogAuth plugin;
    private final UserManagementAPI userAPI;
    private final LanguageFile languageFile;
    private final Vars vars;
    private final LogAuthLogger logger;
    private final boolean IS_PIN_ENABLED = LogAuth.getLogAuth().getConfig().getBoolean("logAuth.Options.UsePINInsteadOfPassword");

    public RegisterCommand() {
        this.plugin = LogAuth.getLogAuth();
        this.userAPI = UserManagementAPI.getUserManagementAPI();
        this.languageFile = LanguageFile.getInstance();
        this.vars = Vars.getVars();
        this.logger = LogAuthLogger.getLogAuthLogger();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase(COMMAND_NAME)) {
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be executed by players.");
            return true;
        }
        if (this.IS_PIN_ENABLED) {
            this.sendLocalizedMessage((Player)sender, "PINIsEnabled");
            return true;
        }
        Player player = (Player)sender;
        return this.handleRegisterCommand(player, args);
    }

    private boolean handleRegisterCommand(Player player, String[] args) {
        if (this.userAPI.isUserRegistererd(player.getName())) {
            this.sendLocalizedMessage(player, "AlreadyRegistered");
            return true;
        }
        if (!this.validateArguments(player, args)) {
            return true;
        }
        String password = args[0];
        PasswordValidationResult validationResult = this.validatePassword(password);
        if (!validationResult.isValid()) {
            this.sendLocalizedMessage(player, validationResult.getErrorMessageKey());
            return true;
        }
        this.registerUser(player, password);
        return true;
    }

    private boolean validateArguments(Player player, String[] args) {
        if (args.length != 1) {
            this.sendLocalizedMessage(player, "RegisterCommandUsage");
            return false;
        }
        return true;
    }

    private PasswordValidationResult validatePassword(String password) {
        int minLength = this.plugin.getConfig().getInt("logAuth.MinLength");
        int maxLength = this.plugin.getConfig().getInt("logAuth.MaxLength");
        if (this.plugin.getConfig().getBoolean("logAuth.Options.UseMinPasswordLenght") && password.length() < minLength) {
            return new PasswordValidationResult(false, "PasswordToSmall");
        }
        if (this.plugin.getConfig().getBoolean("logAuth.Options.UseMaxPasswordLength") && password.length() > maxLength) {
            return new PasswordValidationResult(false, "PasswordToLong");
        }
        return new PasswordValidationResult(true, null);
    }

    private void registerUser(Player player, String password) {
        String playerName = player.getName();
        this.userAPI.registerNewUser(playerName, password, true);
        this.userAPI.generateBackupCode(playerName);
        this.logger.log(playerName + " registered successfully!");
        String backupCode = this.userAPI.getBackupCode(playerName);
        String successMessage = String.format("%s\u00a77You've \u00a7asuccessfully \u00a77registered yourself with the password \u00a7e%s\u00a77. Your \u00a7eBackup-Code \u00a77is \u00a7e%s\u00a77.", this.vars.pr, password, backupCode);
        player.sendMessage(successMessage);
        this.vars.logOut.remove(player);
        this.handleTeleportBack(player, playerName);
    }

    private void handleTeleportBack(Player player, String playerName) {
        boolean shouldTeleport = this.plugin.getConfig().getBoolean("logAuth.Options.TeleportNotLoggedInPlayers");
        boolean hasSpawnLocation = this.userAPI.isNotLoggedInSpawnLocationSet();
        if (shouldTeleport && hasSpawnLocation) {
            player.teleport(this.userAPI.getTemporaryLocation(playerName));
            this.userAPI.deleteTemporaryLocationSection(playerName);
        }
    }

    private void sendLocalizedMessage(Player player, String messageKey) {
        String currentLanguage = this.vars.currentLanguage;
        String messagePath = currentLanguage + ".Messages." + messageKey;
        String message = this.languageFile.getLanguageConfig().getString(messagePath);
        if (message != null) {
            String coloredMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
            player.sendMessage(this.vars.pr + coloredMessage);
        } else {
            player.sendMessage(this.vars.pr + "\u00a7cMessage not found: " + messageKey);
        }
    }

    private static class PasswordValidationResult {
        private final boolean valid;
        private final String errorMessageKey;

        public PasswordValidationResult(boolean valid, String errorMessageKey) {
            this.valid = valid;
            this.errorMessageKey = errorMessageKey;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getErrorMessageKey() {
            return this.errorMessageKey;
        }
    }
}

