/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logauth.commands;

import de.tofastforyou.logauth.LogAuth;
import de.tofastforyou.logauth.files.LanguageFile;
import de.tofastforyou.logauth.util.Vars;
import de.tofastforyou.logauth.util.inventories.ManagementMenuGUI;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LogAdminCommand
implements CommandExecutor {
    private static final String COMMAND_NAME = "logadmin";
    private final boolean IS_PIN_ENABLED = LogAuth.getLogAuth().getConfig().getBoolean("logAuth.Options.UsePINInsteadOfPassword");

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!this.isValidCommand(cmd, sender)) {
            return false;
        }
        if (this.IS_PIN_ENABLED) {
            sender.sendMessage(this.formatMessage(this.getLocalizedMessage("Messages.PINIsEnabled")));
            return true;
        }
        Player player = (Player)sender;
        if (this.hasPermission(player)) {
            this.openManagementMenu(player);
            return true;
        }
        this.sendNoPermissionMessage(player);
        return false;
    }

    private boolean isValidCommand(Command cmd, CommandSender sender) {
        return cmd.getName().equalsIgnoreCase(COMMAND_NAME) && sender instanceof Player;
    }

    private boolean hasPermission(Player player) {
        String permission = LogAuth.getLogAuth().getConfig().getString("logAuth.Permissions.logAdmin");
        return player.hasPermission(permission);
    }

    private void openManagementMenu(Player player) {
        String message = this.getLocalizedMessage("Messages.OpenMenu");
        player.sendMessage(this.formatMessage(message));
        ManagementMenuGUI.getManagementMenuGUI().openGUI(player);
    }

    private void sendNoPermissionMessage(Player player) {
        String message = this.getLocalizedMessage("Messages.NoPermission");
        player.sendMessage(this.formatMessage(message));
    }

    private String getLocalizedMessage(String messageKey) {
        String languageKey = Vars.getVars().currentLanguage + "." + messageKey;
        return LanguageFile.getInstance().getLanguageConfig().getString(languageKey);
    }

    private String formatMessage(String message) {
        return Vars.getVars().pr + ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }
}

