/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logauth.api;

import de.tofastforyou.logauth.security.AESCryptoUtil;
import de.tofastforyou.logauth.security.PasswordUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class UserManagementAPI {
    private static final UserManagementAPI INSTANCE = new UserManagementAPI();
    private static final AESCryptoUtil CRYPTO = new AESCryptoUtil();
    private static final String DB_PATH = "plugins/LogAuth/data/userdata.db";
    private Connection connection;

    private UserManagementAPI() {
        this.initializeDatabase();
    }

    public static UserManagementAPI getUserManagementAPI() {
        return INSTANCE;
    }

    private void initializeDatabase() {
        try {
            boolean created;
            File dataDir = new File("plugins/LogAuth/data/");
            if (!dataDir.exists() && !(created = dataDir.mkdirs())) {
                throw new RuntimeException("Could not create data directory: " + dataDir.getAbsolutePath());
            }
            if (!dataDir.canWrite()) {
                throw new RuntimeException("No write permission for data directory: " + dataDir.getAbsolutePath());
            }
            try {
                Class.forName("org.sqlite.JDBC");
                System.out.println("[logAuth] SQLite JDBC driver loaded successfully");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("SQLite JDBC driver not found!", e);
            }
            this.connection = DriverManager.getConnection("jdbc:sqlite:plugins/LogAuth/data/userdata.db");
            if (this.connection == null || this.connection.isClosed()) {
                throw new SQLException("Failed to establish database connection");
            }
            try (Statement stmt = this.connection.createStatement();){
                stmt.execute("PRAGMA journal_mode=WAL;");
                stmt.execute("PRAGMA synchronous=NORMAL;");
            }
            this.createTables();
            System.out.println("[logAuth] Database initialized successfully");
        }
        catch (SQLException e) {
            System.err.println("[logAuth] Database SQL error:");
            System.err.println("DB_PATH: plugins/LogAuth/data/userdata.db");
            System.err.println("Error Code: " + e.getErrorCode());
            System.err.println("SQL State: " + e.getSQLState());
            System.err.println("Message: " + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("Failed to initialize database", e);
        }
        catch (Exception e) {
            System.err.println("[logAuth] General database initialization error:");
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("Failed to initialize database", e);
        }
    }

    private void createTables() throws SQLException {
        String createUsersTable = "    CREATE TABLE IF NOT EXISTS users (\n        username TEXT PRIMARY KEY,\n        password_encrypted TEXT,\n        is_registered BOOLEAN DEFAULT FALSE,\n        backup_code TEXT\n    )\n";
        String createRegisteredPlayersTable = "    CREATE TABLE IF NOT EXISTS registered_players (\n        username TEXT PRIMARY KEY\n    )\n";
        String createLoggedInPlayersTable = "    CREATE TABLE IF NOT EXISTS logged_in_players (\n        username TEXT PRIMARY KEY\n    )\n";
        String createLocationTable = "    CREATE TABLE IF NOT EXISTS locations (\n        id TEXT PRIMARY KEY,\n        world_name TEXT,\n        x REAL,\n        y REAL,\n        z REAL,\n        yaw REAL,\n        pitch REAL\n    )\n";
        String createPinTable = "    CREATE TABLE IF NOT EXISTS pins (\n        username TEXT PRIMARY KEY,\n        pin TEXT\n    )\n";
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(createUsersTable);
            stmt.execute(createRegisteredPlayersTable);
            stmt.execute(createLoggedInPlayersTable);
            stmt.execute(createLocationTable);
            stmt.execute(createPinTable);
        }
    }

    private Connection getConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            this.initializeDatabase();
        }
        return this.connection;
    }

    public void registerNewUser(String username, String password, boolean registered) {
        String hashedPassword = PasswordUtils.hashPasword(password);
        String sql = "INSERT OR REPLACE INTO users (username, password_encrypted, is_registered) VALUES (?, ?, ?)";
        try (PreparedStatement pstmt = this.getConnection().prepareStatement(sql);){
            pstmt.setString(1, username);
            pstmt.setString(2, hashedPassword);
            pstmt.setBoolean(3, registered);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.addPlayerToList(username);
    }

    public void generateBackupCode(String username) {
        String randomHex = Integer.toHexString(new Random().nextInt(709581));
        String encryptedCode = null;
        try {
            encryptedCode = CRYPTO.encrypt(randomHex);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String sql = "UPDATE users SET backup_code = ? WHERE username = ?";
        try (PreparedStatement pstmt = this.getConnection().prepareStatement(sql);){
            pstmt.setString(1, encryptedCode);
            pstmt.setString(2, username);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void resetUser(String username) {
        String sql = "UPDATE users SET is_registered = FALSE WHERE username = ?";
        try (PreparedStatement pstmt = this.getConnection().prepareStatement(sql);){
            pstmt.setString(1, username);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.removePlayerFromList(username);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPassword(String username) {
        String sql = "SELECT password_encrypted FROM users WHERE username = ?";
        try (PreparedStatement pstmt = this.getConnection().prepareStatement(sql);){
            pstmt.setString(1, username);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return null;
            String string = rs.getString("password_encrypted");
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getBackupCode(String username) {
        String sql = "SELECT backup_code FROM users WHERE username = ?";
        try (PreparedStatement pstmt = this.getConnection().prepareStatement(sql);){
            String encryptedCode;
            pstmt.setString(1, username);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next() && (encryptedCode = rs.getString("backup_code")) != null) {
                try {
                    String string = CRYPTO.decrypt(encryptedCode);
                    return string;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public boolean isPasswordEqual(String username, String password) {
        return PasswordUtils.checkPasword(password, this.getPassword(username));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isUserRegistererd(String username) {
        String sql = "SELECT is_registered FROM users WHERE username = ?";
        try (PreparedStatement pstmt = this.getConnection().prepareStatement(sql);){
            pstmt.setString(1, username);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return false;
            boolean bl = rs.getBoolean("is_registered");
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isBackupCodeEqual(String username, String backupCode) {
        String storedCode = this.getBackupCode(username);
        return storedCode != null && backupCode.equals(storedCode);
    }

    public void addPlayerToList(String username) {
        String sql = "INSERT OR IGNORE INTO registered_players (username) VALUES (?)";
        try (PreparedStatement pstmt = this.getConnection().prepareStatement(sql);){
            pstmt.setString(1, username);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void removePlayerFromList(String username) {
        String sql = "DELETE FROM registered_players WHERE username = ?";
        try (PreparedStatement pstmt = this.getConnection().prepareStatement(sql);){
            pstmt.setString(1, username);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getPlayerList() {
        ArrayList<String> playerList = new ArrayList<String>();
        String sql = "SELECT username FROM registered_players";
        try (Statement stmt = this.getConnection().createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                playerList.add(rs.getString("username"));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return playerList;
    }

    public void createNotLoggedInSpawn(Location location) {
        String sql = "INSERT OR REPLACE INTO locations (id, world_name, x, y, z, yaw, pitch) VALUES (?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement pstmt = this.getConnection().prepareStatement(sql);){
            pstmt.setString(1, "not_logged_in_spawn");
            pstmt.setString(2, location.getWorld().getName());
            pstmt.setDouble(3, location.getX());
            pstmt.setDouble(4, location.getY());
            pstmt.setDouble(5, location.getZ());
            pstmt.setFloat(6, location.getYaw());
            pstmt.setFloat(7, location.getPitch());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Location getNotLoggedInSpawnLocation() {
        String sql = "SELECT * FROM locations WHERE id = ?";
        try (PreparedStatement pstmt = this.getConnection().prepareStatement(sql);){
            pstmt.setString(1, "not_logged_in_spawn");
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return null;
            String worldName = rs.getString("world_name");
            World world = Bukkit.getWorld((String)worldName);
            double x = rs.getDouble("x");
            double y = rs.getDouble("y");
            double z = rs.getDouble("z");
            float yaw = rs.getFloat("yaw");
            float pitch = rs.getFloat("pitch");
            Location location = new Location(world, x, y, z, yaw, pitch);
            return location;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isNotLoggedInSpawnLocationSet() {
        String sql = "SELECT COUNT(*) FROM locations WHERE id = ?";
        try (PreparedStatement pstmt = this.getConnection().prepareStatement(sql);){
            pstmt.setString(1, "not_logged_in_spawn");
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return false;
            boolean bl = rs.getInt(1) > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void teleportPlayerToNotLoggedInLocation(Player player) {
        Location location = this.getNotLoggedInSpawnLocation();
        if (location != null) {
            player.teleport(location);
        }
    }

    public void saveLocationTemporarily(Location location, String playerName) {
        String sql = "INSERT OR REPLACE INTO locations (id, world_name, x, y, z, yaw, pitch) VALUES (?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement pstmt = this.getConnection().prepareStatement(sql);){
            pstmt.setString(1, "temp_" + playerName);
            pstmt.setString(2, location.getWorld().getName());
            pstmt.setDouble(3, location.getX());
            pstmt.setDouble(4, location.getY());
            pstmt.setDouble(5, location.getZ());
            pstmt.setFloat(6, location.getYaw());
            pstmt.setFloat(7, location.getPitch());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Location getTemporaryLocation(String playerName) {
        String sql = "SELECT * FROM locations WHERE id = ?";
        try (PreparedStatement pstmt = this.getConnection().prepareStatement(sql);){
            pstmt.setString(1, "temp_" + playerName);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return null;
            String worldName = rs.getString("world_name");
            World world = Bukkit.getWorld((String)worldName);
            double x = rs.getDouble("x");
            double y = rs.getDouble("y");
            double z = rs.getDouble("z");
            float yaw = rs.getFloat("yaw");
            float pitch = rs.getFloat("pitch");
            Location location = new Location(world, x, y, z, yaw, pitch);
            return location;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteTemporaryLocationSection(String playerName) {
        String sql = "DELETE FROM locations WHERE id = ?";
        try (PreparedStatement pstmt = this.getConnection().prepareStatement(sql);){
            pstmt.setString(1, "temp_" + playerName);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean checkPIN(String pin, String playerName) {
        return PasswordUtils.checkPasword(pin, this.getCurrentPIN(playerName));
    }

    public void setPINNumber(String pin, String playerName) {
        String sql = "INSERT OR REPLACE INTO pins (username, pin) VALUES (?, ?)";
        try (PreparedStatement pstmt = this.getConnection().prepareStatement(sql);){
            pstmt.setString(1, playerName);
            pstmt.setString(2, PasswordUtils.hashPasword(pin));
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isPINCreated(String playerName) {
        String pin = this.getCurrentPIN(playerName);
        return pin != null && !pin.isEmpty();
    }

    public List<String> getLoggedInList() {
        ArrayList<String> loggedInList = new ArrayList<String>();
        String sql = "SELECT username FROM logged_in_players";
        try (Statement stmt = this.getConnection().createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                loggedInList.add(rs.getString("username"));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return loggedInList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasPlayerLoggedIn(String playerName) {
        String sql = "SELECT COUNT(*) FROM logged_in_players WHERE username = ?";
        try (PreparedStatement pstmt = this.getConnection().prepareStatement(sql);){
            pstmt.setString(1, playerName);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return false;
            boolean bl = rs.getInt(1) > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void addPlayerToLoggedInList(String username) {
        String sql = "INSERT OR IGNORE INTO logged_in_players (username) VALUES (?)";
        try (PreparedStatement pstmt = this.getConnection().prepareStatement(sql);){
            pstmt.setString(1, username);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCurrentPIN(String playerName) {
        String sql = "SELECT pin FROM pins WHERE username = ?";
        try (PreparedStatement pstmt = this.getConnection().prepareStatement(sql);){
            pstmt.setString(1, playerName);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return null;
            String string = rs.getString("pin");
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void closeConnection() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

