/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logauth.util;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;

public class CommandLogFilter
extends AbstractFilter {
    private List<String> COMMANDS_TO_FILTER = List.of("/login", "/register", "/backupcode", "/reset", "/adminreset");
    private final boolean USE_RAW_STRING = false;

    public CommandLogFilter() {
        super(Filter.Result.DENY, Filter.Result.NEUTRAL);
    }

    private Filter.Result doFilter(@Nullable String message) {
        if (message == null) {
            return this.onMismatch;
        }
        for (String command : this.COMMANDS_TO_FILTER) {
            if (!message.contains(command)) continue;
            return this.onMatch;
        }
        return this.onMismatch;
    }

    public Filter.Result filter(LogEvent event) {
        Message msg = event == null ? null : event.getMessage();
        String message = msg == null ? null : msg.getFormattedMessage();
        return this.doFilter(message);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        return this.doFilter(msg == null ? null : msg.toString());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        return this.doFilter(msg == null ? null : msg.toString());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        String message = msg == null ? null : msg.getFormattedMessage();
        return this.doFilter(message);
    }
}

