/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logauth.listener;

import de.tofastforyou.logauth.api.UserManagementAPI;
import de.tofastforyou.logauth.util.Vars;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;

public class InventoryClickListener
implements Listener {
    private static final String GUI_TITLE = Vars.getVars().pr + "\u00a77Mangement-GUI";
    private static final String LIST_USERS_DISPLAY_NAME = "\u00a7eList all registered user";
    private static final String RESET_PASSWORDS_DISPLAY_NAME = "\u00a7cReset all \u00a7epasswords";
    private static final String SET_SPAWN_DISPLAY_NAME = "\u00a7eSet the NotLoggedIn spawn";

    @EventHandler
    public void onInvClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (!this.isManagementGUI(event)) {
            return;
        }
        event.setCancelled(true);
        String displayName = event.getCurrentItem().getItemMeta().getDisplayName();
        if (LIST_USERS_DISPLAY_NAME.equals(displayName)) {
            this.handleListUsers(player);
        } else if (RESET_PASSWORDS_DISPLAY_NAME.equals(displayName)) {
            this.handleResetPasswords(player);
        } else if (SET_SPAWN_DISPLAY_NAME.equals(displayName)) {
            this.handleSetSpawn(player);
        }
    }

    private boolean isManagementGUI(InventoryClickEvent event) {
        return GUI_TITLE.equals(event.getView().getTitle());
    }

    private void handleListUsers(Player player) {
        player.closeInventory();
        player.sendMessage(Vars.getVars().pr + "\u00a77Registered players:");
        UserManagementAPI.getUserManagementAPI().getPlayerList().forEach(playerName -> this.sendPlayerListEntry(player, (String)playerName));
    }

    private void sendPlayerListEntry(Player player, String playerName) {
        TextComponent component = new TextComponent("\u00a77- \u00a7e" + playerName);
        component.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/adminreset " + playerName));
        component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Click here to reset the \u00a7epassword \u00a77of \u00a7e" + playerName + "\u00a77!").create()));
        player.spigot().sendMessage((BaseComponent)component);
    }

    private void handleResetPasswords(Player player) {
        player.closeInventory();
        player.sendMessage(Vars.getVars().pr + "\u00a77Are you sure?");
        TextComponent[] confirmationMessage = this.createConfirmationMessage("/adminreset all", "\u00a77Click here to \u00a7creset\u00a77 all \u00a7epasswords\u00a77!");
        player.spigot().sendMessage((BaseComponent[])confirmationMessage);
    }

    private void handleSetSpawn(Player player) {
        player.closeInventory();
        if (UserManagementAPI.getUserManagementAPI().isNotLoggedInSpawnLocationSet()) {
            this.showSetSpawnConfirmation(player);
        } else {
            this.setNotLoggedInSpawn(player);
        }
    }

    private void showSetSpawnConfirmation(Player player) {
        player.sendMessage(Vars.getVars().pr + "\u00a77Are you sure?");
        TextComponent[] confirmationMessage = this.createConfirmationMessage("/setnotloggedinspawn", "\u00a77Click \u00a7ehere \u00a77to set the new \u00a7eNotLoggedInSpawn \u00a77location!");
        player.spigot().sendMessage((BaseComponent[])confirmationMessage);
    }

    private void setNotLoggedInSpawn(Player player) {
        UserManagementAPI.getUserManagementAPI().createNotLoggedInSpawn(player.getLocation());
        player.sendMessage(Vars.getVars().pr + "\u00a77You \u00a7asuccessfully \u00a77saved the \u00a7eNotLoggedInSpawn \u00a77location!");
    }

    private TextComponent[] createConfirmationMessage(String yesCommand, String yesHoverText) {
        TextComponent prefix = new TextComponent(Vars.getVars().pr);
        TextComponent yes = new TextComponent("\u00a7a\u00a7l[YES] ");
        yes.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, yesCommand));
        yes.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(yesHoverText).create()));
        TextComponent no = new TextComponent("\u00a7c\u00a7l[NO]");
        no.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/logadmin"));
        no.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Click here to get back to the \u00a7emenu\u00a77!").create()));
        return new TextComponent[]{prefix, yes, no};
    }
}

