/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logauth.files;

import de.tofastforyou.logauth.util.ErrorSaver;
import de.tofastforyou.logauth.util.ErrorTypes;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;

public class LanguageFile {
    private static final LanguageFile INSTANCE = new LanguageFile();
    private static final String LANGUAGE_FILE_PATH = "plugins/logAuth/Language/Messages.yml";
    private final File languageFile = new File("plugins/logAuth/Language/Messages.yml");
    private final YamlConfiguration languageConfig = YamlConfiguration.loadConfiguration((File)this.languageFile);

    private LanguageFile() {
    }

    public static LanguageFile getInstance() {
        return INSTANCE;
    }

    public YamlConfiguration getLanguageConfig() {
        return this.languageConfig;
    }

    public void initializeDefaultMessages() {
        Map<String, String> defaultMessages = this.createDefaultMessages();
        for (Map.Entry<String, String> entry : defaultMessages.entrySet()) {
            this.languageConfig.addDefault(entry.getKey(), (Object)entry.getValue());
        }
        this.languageConfig.options().copyDefaults(true);
        this.saveConfiguration();
    }

    private Map<String, String> createDefaultMessages() {
        HashMap<String, String> messages = new HashMap<String, String>();
        messages.put("en-EN.Messages.ResetCommandUsage", "&cUsage: /reset <BackupCode>");
        messages.put("en-EN.Messages.PasswordReset", "&7You reset your &epassword&7!");
        messages.put("en-EN.Messages.ResetKickMessage", "&7You reset your &epassword&7! Please &erejoin&7!");
        messages.put("en-EN.Messages.BackupCodeIncorrect", "&cThe &eBackup-Code &cyou've entered is &4incorrect&c!");
        messages.put("en-EN.Messages.RegisterCommandUsage", "&cUsage: /register <Password>");
        messages.put("en-EN.Messages.AlreadyRegistered", "&cYou are already registered!");
        messages.put("en-EN.Messages.PasswordToSmall", "&cThe password you've entered is too &4small&c!");
        messages.put("en-EN.Messages.PasswordToLong", "&cThe password you've entered is too &4long&c!");
        messages.put("en-EN.Messages.LoginUsage", "&cUsage: /login <Password>");
        messages.put("en-EN.Messages.NotRegistered", "&cYou are not registered!");
        messages.put("en-EN.Messages.PasswordIsCorrect", "&7You've entered the &acorrect &epassword&7!");
        messages.put("en-EN.Messages.PasswordIsIncorrect", "&cThe password you've entered is &4incorrect&c!");
        messages.put("en-EN.Messages.BackupCodeCommandUsage", "&cUsage: /backupcode");
        messages.put("en-EN.Messages.LoginReminder", "&cYou have to login &eyourself &cby using &e/login <Password>&c. You have &e30 Seconds &cto do this!");
        messages.put("en-EN.Messages.RegisterReminder", "&cYou have to register &eyourself &cby using &e/register <Password>&c. You have &e30 Seconds &cto do this!");
        messages.put("en-EN.Messages.AdminresetUsage", "&cUsage: /adminreset <Player>");
        messages.put("en-EN.Messages.UserReset", "&7You &asuccessfully &7reset the &epassword&7!");
        messages.put("en-EN.Messages.UserNotRegistered", "&cThis user is &4not &cregistered!");
        messages.put("en-EN.Messages.NoPermission", "&cYou have no permissions to perform this command!");
        messages.put("en-EN.Messages.AllReset", "&7You reset &call &epasswords&7!");
        messages.put("en-EN.Messages.OpenMenu", "&7You opened the &elogAdmin-Menu&7!");
        messages.put("en-EN.Messages.KickMessage", "&7You got kicked because you take too much time!");
        messages.put("en-EN.Messages.SetNotLoggedInSpawnCommandUsage", "&cUsage: /setnotloggedinspawn");
        messages.put("en-EN.Messages.NotLoggedInSpawnNotSet", "&cThe &eNotLoggedInSpawn &clocation was &4not &cfound! Please contact the server administrator to solve this problem!");
        messages.put("en-EN.Messages.ExistingInLoggedInList", "&aYou've logged in lately, and you do not need to log in now!");
        messages.put("en-EN.Messages.AddedToLoggedInList", "&aYou do not have to log in anymore!");
        return messages;
    }

    public String getMessage(String key) {
        return this.languageConfig.getString(key, "&cMessage not found: " + key);
    }

    public void saveConfiguration() {
        try {
            this.languageConfig.save(this.languageFile);
        }
        catch (IOException e) {
            ErrorSaver.getErrorSaver().saveError(ErrorTypes.FILE_SAVE_FAIL, this.getClass().getSimpleName(), "Could not save the Messages.yml file: " + e.getMessage());
        }
    }

    public boolean reloadConfiguration() {
        try {
            this.languageConfig.load(this.languageFile);
            return true;
        }
        catch (Exception e) {
            ErrorSaver.getErrorSaver().saveError(ErrorTypes.FILE_SAVE_FAIL, this.getClass().getSimpleName(), "Could not reload the Messages.yml file: " + e.getMessage());
            return false;
        }
    }
}

