/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logauth.commands;

import de.tofastforyou.logauth.api.UserManagementAPI;
import de.tofastforyou.logauth.files.LanguageFile;
import de.tofastforyou.logauth.util.ErrorSaver;
import de.tofastforyou.logauth.util.ErrorTypes;
import de.tofastforyou.logauth.util.LogAuthLogger;
import de.tofastforyou.logauth.util.Vars;
import java.util.concurrent.TimeUnit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ResetUserCommand
implements CommandExecutor {
    private static final String COMMAND_NAME = "reset";
    private static final int SLEEP_DURATION_SECONDS = 1;

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!this.isValidCommand(cmd, sender)) {
            return false;
        }
        Player player = (Player)sender;
        if (!this.isValidArgumentCount(args)) {
            this.sendUsageMessage(player);
            return false;
        }
        return this.handleResetCommand(player, args[0]);
    }

    private boolean isValidCommand(Command cmd, CommandSender sender) {
        return cmd.getName().equalsIgnoreCase(COMMAND_NAME) && sender instanceof Player;
    }

    private boolean isValidArgumentCount(String[] args) {
        return args.length == 1;
    }

    private void sendUsageMessage(Player player) {
        String message = this.buildMessage("Messages.ResetCommandUsage");
        player.sendMessage(message);
    }

    private boolean handleResetCommand(Player player, String backupCode) {
        if (!this.isBackupCodeValid(player.getName(), backupCode)) {
            this.sendIncorrectBackupCodeMessage(player);
            return true;
        }
        this.resetPlayerPassword(player);
        return true;
    }

    private boolean isBackupCodeValid(String playerName, String backupCode) {
        return UserManagementAPI.getUserManagementAPI().isBackupCodeEqual(playerName, backupCode);
    }

    private void sendIncorrectBackupCodeMessage(Player player) {
        String message = this.buildMessage("Messages.BackupCodeIncorrect");
        player.sendMessage(message);
    }

    private void resetPlayerPassword(Player player) {
        String playerName = player.getName();
        UserManagementAPI.getUserManagementAPI().resetUser(playerName);
        this.sendPasswordResetMessage(player);
        this.sleepThread();
        this.logPasswordReset(playerName);
        this.kickPlayerWithMessage(player);
    }

    private void sendPasswordResetMessage(Player player) {
        String message = this.buildMessage("Messages.PasswordReset");
        player.sendMessage(message);
    }

    private void sleepThread() {
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException e) {
            this.handleSleepInterruption();
        }
    }

    private void handleSleepInterruption() {
        ErrorSaver.getErrorSaver().saveError(ErrorTypes.UNKNOWN_ERROR, this.toString(), "Could not sleep thread in reset command!");
    }

    private void logPasswordReset(String playerName) {
        LogAuthLogger.getLogAuthLogger().log(playerName + " reset their password!");
    }

    private void kickPlayerWithMessage(Player player) {
        String kickMessage = this.buildMessage("Messages.ResetKickMessage");
        player.kickPlayer(kickMessage);
    }

    private String buildMessage(String messageKey) {
        String prefix = Vars.getVars().pr;
        String languageKey = Vars.getVars().currentLanguage + "." + messageKey;
        String rawMessage = LanguageFile.getInstance().getLanguageConfig().getString(languageKey);
        String coloredMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)rawMessage);
        return prefix + coloredMessage;
    }
}

