/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logauth.commands;

import de.tofastforyou.logauth.LogAuth;
import de.tofastforyou.logauth.api.UserManagementAPI;
import de.tofastforyou.logauth.files.LanguageFile;
import de.tofastforyou.logauth.util.LogAuthLogger;
import de.tofastforyou.logauth.util.Vars;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LoginCommand
implements CommandExecutor {
    private final UserManagementAPI userAPI = UserManagementAPI.getUserManagementAPI();
    private final LanguageFile languageFile = LanguageFile.getInstance();
    private final LogAuthLogger logger = LogAuthLogger.getLogAuthLogger();
    private final Vars vars = Vars.getVars();
    private final LogAuth plugin = LogAuth.getLogAuth();

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!this.isValidLoginCommand(cmd, sender)) {
            return false;
        }
        Player player = (Player)sender;
        if (!this.isPlayerRegistered(player)) {
            return false;
        }
        if (!this.hasValidArguments(args, player)) {
            return false;
        }
        return this.processLogin(player, args[0]);
    }

    private boolean isValidLoginCommand(Command cmd, CommandSender sender) {
        return cmd.getName().equalsIgnoreCase("login") && sender instanceof Player;
    }

    private boolean isPlayerRegistered(Player player) {
        if (!this.userAPI.isUserRegistererd(player.getName())) {
            this.sendMessage(player, "NotRegistered");
            return false;
        }
        return true;
    }

    private boolean hasValidArguments(String[] args, Player player) {
        if (args.length != 1) {
            this.sendMessage(player, "LoginUsage");
            return false;
        }
        return true;
    }

    private boolean processLogin(Player player, String password) {
        if (this.userAPI.isPasswordEqual(player.getName(), password)) {
            this.handleSuccessfulLogin(player);
            return true;
        }
        this.handleFailedLogin(player);
        return false;
    }

    private void handleSuccessfulLogin(Player player) {
        String playerName = player.getName();
        this.sendMessage(player, "PasswordIsCorrect");
        this.vars.logOut.remove(player);
        this.handleTeleportation(player, playerName);
        this.logger.log(playerName + " logged in successfully!");
        this.handleLoginTracking(player, playerName);
    }

    private void handleTeleportation(Player player, String playerName) {
        boolean shouldTeleport = this.plugin.getConfig().getBoolean("logAuth.Options.TeleportNotLoggedInPlayers");
        boolean hasSpawnLocation = this.userAPI.isNotLoggedInSpawnLocationSet();
        if (shouldTeleport && hasSpawnLocation) {
            player.teleport(this.userAPI.getTemporaryLocation(playerName));
            this.userAPI.deleteTemporaryLocationSection(playerName);
        }
    }

    private void handleLoginTracking(Player player, String playerName) {
        boolean hasNotLoggedInBefore;
        boolean shouldSaveLogins = this.plugin.getConfig().getBoolean("logAuth.Options.SavePlayersWhoLoggedIn");
        boolean bl = hasNotLoggedInBefore = !this.userAPI.hasPlayerLoggedIn(playerName);
        if (shouldSaveLogins && hasNotLoggedInBefore) {
            this.userAPI.addPlayerToLoggedInList(playerName);
            this.sendMessage(player, "FirstTimeLogin");
        }
    }

    private void handleFailedLogin(Player player) {
        this.sendMessage(player, "PasswordIsIncorrect");
        this.logger.log(player.getName() + " could not log in!");
    }

    private void sendMessage(Player player, String messageKey) {
        String message = this.getLocalizedMessage(messageKey);
        player.sendMessage(this.vars.pr + ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }

    private String getLocalizedMessage(String messageKey) {
        String path = this.vars.currentLanguage + ".Messages." + messageKey;
        return this.languageFile.getLanguageConfig().getString(path, "Message not found: " + messageKey);
    }
}

