/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logauth.commands;

import de.tofastforyou.logauth.api.UserManagementAPI;
import de.tofastforyou.logauth.files.LanguageFile;
import de.tofastforyou.logauth.util.Vars;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BackupCodeCommand
implements CommandExecutor {
    private static final String COMMAND_NAME = "backupcode";
    private static final String MESSAGE_PATH_PREFIX = ".Messages.";
    private static final String BACKUP_CODE_MESSAGE_FORMAT = "\u00a77Click \u00a7ehere \u00a77to copy your \u00a7eBackupcode \u00a77to your clipboard!";

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase(COMMAND_NAME)) {
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.getFormattedMessage("OnlyPlayersCanUseCommand"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length > 0) {
            this.sendUsageMessage(player);
            return true;
        }
        this.sendBackupCode(player);
        return true;
    }

    private void sendUsageMessage(Player player) {
        String usageMessage = this.getLanguageMessage("BackupCodeCommandUsage");
        player.sendMessage(this.getPrefix() + usageMessage);
    }

    private void sendBackupCode(Player player) {
        String backupCode = UserManagementAPI.getUserManagementAPI().getBackupCode(player.getName());
        TextComponent textComponent = new TextComponent(this.getPrefix() + BACKUP_CODE_MESSAGE_FORMAT);
        textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, backupCode));
        textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Copy your \u00a7eBackupcode\u00a77!").create()));
        player.spigot().sendMessage((BaseComponent)textComponent);
    }

    private String getLanguageMessage(String messageKey) {
        String currentLanguage = Vars.getVars().currentLanguage;
        String messagePath = currentLanguage + MESSAGE_PATH_PREFIX + messageKey;
        String rawMessage = LanguageFile.getInstance().getLanguageConfig().getString(messagePath, "Message not found");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)rawMessage);
    }

    private String getFormattedMessage(String messageKey) {
        return this.getPrefix() + this.getLanguageMessage(messageKey);
    }

    private String getPrefix() {
        return Vars.getVars().pr;
    }
}

