/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.morefoworld.minelib.util.subcommand;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.hsgamer.morefoworld.minelib.util.subcommand.SubCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class SubCommandManager {
    protected static final String HELP = "help";
    protected final Map<String, SubCommand> subcommands = new HashMap<String, SubCommand>();

    public final boolean onCommand(@NotNull CommandSender sender, @NotNull String label, String ... args) {
        if (args.length < 1 || args[0].equalsIgnoreCase(HELP)) {
            this.sendHelpMessage(sender, label, args);
            return true;
        }
        if (!this.subcommands.containsKey(args[0])) {
            this.sendArgNotFoundMessage(sender, label, args);
            return false;
        }
        return this.subcommands.get(args[0]).onCommand(sender, label, Arrays.copyOfRange(args, 1, args.length));
    }

    public void sendHelpMessage(@NotNull CommandSender sender, @NotNull String label, String ... args) {
        for (SubCommand subcommand : this.subcommands.values()) {
            sender.sendMessage(ChatColor.YELLOW + subcommand.usage.replace("<label>", label));
            sender.sendMessage(ChatColor.WHITE + "  " + subcommand.description);
        }
    }

    public void sendArgNotFoundMessage(@NotNull CommandSender sender, @NotNull String label, String ... args) {
        sender.sendMessage(ChatColor.RED + "Argument not found");
    }

    public final void registerSubcommand(@NotNull SubCommand subCommand) {
        if (subCommand.name.equalsIgnoreCase(HELP)) {
            throw new IllegalArgumentException("'help' is a predefined argument");
        }
        this.subcommands.put(subCommand.getName(), subCommand);
    }

    public final void unregisterSubcommand(@NotNull String name) {
        this.subcommands.remove(name);
    }

    public final void unregisterSubcommand(@NotNull SubCommand subCommand) {
        this.subcommands.remove(subCommand.getName());
    }

    @NotNull
    public final Map<String, SubCommand> getSubcommands() {
        return Collections.unmodifiableMap(this.subcommands);
    }

    public final List<String> onTabComplete(@NotNull CommandSender sender, @NotNull String label, String ... args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length < 1 || args[0].isEmpty()) {
            list.add(HELP);
            list.addAll(this.subcommands.keySet());
        } else if (this.subcommands.containsKey(args[0])) {
            SubCommand subCommand = this.subcommands.get(args[0]);
            if (subCommand.isExecutable(sender, false)) {
                list.addAll(subCommand.onTabComplete(sender, label, Arrays.copyOfRange(args, 1, args.length)));
            }
        } else {
            for (String subLabel : this.subcommands.keySet()) {
                if (!subLabel.startsWith(args[0])) continue;
                list.add(subLabel);
            }
            if (HELP.startsWith(args[0])) {
                list.add(HELP);
            }
        }
        return list;
    }
}

