/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.morefoworld.core.logger.jul;

import java.util.logging.Level;
import me.hsgamer.morefoworld.core.logger.common.LogLevel;
import me.hsgamer.morefoworld.core.logger.common.Logger;

public class JulLogger
implements Logger {
    private final java.util.logging.Logger logger;

    public JulLogger(java.util.logging.Logger logger) {
        this.logger = logger;
    }

    public JulLogger(String name) {
        this(java.util.logging.Logger.getLogger(name));
    }

    public JulLogger(Class<?> clazz) {
        this(clazz.getSimpleName());
    }

    @Override
    public void log(LogLevel level, String message) {
        switch (level) {
            case DEBUG: {
                this.logger.fine(message);
                break;
            }
            case INFO: {
                this.logger.info(message);
                break;
            }
            case WARN: {
                this.logger.warning(message);
                break;
            }
            case ERROR: {
                this.logger.severe(message);
                break;
            }
        }
    }

    @Override
    public void log(LogLevel level, Throwable throwable) {
        this.log(level, throwable.getMessage(), throwable);
    }

    @Override
    public void log(LogLevel level, String message, Throwable throwable) {
        switch (level) {
            case DEBUG: {
                this.logger.log(Level.FINE, message, throwable);
                break;
            }
            case INFO: {
                this.logger.log(Level.INFO, message, throwable);
                break;
            }
            case WARN: {
                this.logger.log(Level.WARNING, message, throwable);
                break;
            }
            case ERROR: {
                this.logger.log(Level.SEVERE, message, throwable);
                break;
            }
        }
    }
}

