/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.morefoworld.core.config.annotation.converter.manager;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import me.hsgamer.morefoworld.core.config.annotation.converter.Converter;
import me.hsgamer.morefoworld.core.config.annotation.converter.ConverterProvider;
import me.hsgamer.morefoworld.core.config.annotation.converter.impl.DefaultArrayConverterProvider;
import me.hsgamer.morefoworld.core.config.annotation.converter.impl.DefaultConverter;
import me.hsgamer.morefoworld.core.config.annotation.converter.impl.PrimitiveConverterProvider;
import me.hsgamer.morefoworld.core.config.annotation.converter.impl.SimpleConverter;
import me.hsgamer.morefoworld.core.config.annotation.converter.impl.StringConverter;

public final class DefaultConverterManager {
    private static final List<ConverterProvider> PROVIDERS = new ArrayList<ConverterProvider>();
    private static final Map<Type, Converter> CONVERTER_MAP = new HashMap<Type, Converter>();

    private DefaultConverterManager() {
    }

    public static void registerProvider(ConverterProvider provider) {
        PROVIDERS.add(provider);
    }

    public static void registerConverter(Type type, Converter converter) {
        CONVERTER_MAP.put(type, converter);
    }

    public static void unregisterConverter(Type type) {
        CONVERTER_MAP.remove(type);
    }

    public static Converter getConverterIfDefault(Type type, Converter converter) {
        if (converter instanceof DefaultConverter) {
            if (CONVERTER_MAP.containsKey(type)) {
                return CONVERTER_MAP.get(type);
            }
            if (type instanceof Class) {
                Class clazz = (Class)type;
                for (ConverterProvider provider : PROVIDERS) {
                    Optional<Converter> optionalConverter = provider.getConverter(clazz);
                    if (!optionalConverter.isPresent()) continue;
                    Converter finalConverter = optionalConverter.get();
                    CONVERTER_MAP.put(type, finalConverter);
                    return finalConverter;
                }
            }
        }
        return converter;
    }

    public static Converter getConverterIfDefault(Type type, Class<? extends Converter> converterClass) {
        return DefaultConverterManager.getConverterIfDefault(type, Converter.createConverterSafe(converterClass));
    }

    public static Converter getConverter(Type type) {
        return DefaultConverterManager.getConverterIfDefault(type, new DefaultConverter());
    }

    static {
        DefaultConverterManager.registerProvider(new PrimitiveConverterProvider());
        DefaultConverterManager.registerProvider(new DefaultArrayConverterProvider());
        DefaultConverterManager.registerConverter(String.class, new SimpleConverter(Objects::toString));
        DefaultConverterManager.registerConverter(URI.class, StringConverter.of(URI::create, URI::toString));
        DefaultConverterManager.registerConverter(URL.class, StringConverter.of(s -> {
            try {
                return new URL((String)s);
            }
            catch (Exception e) {
                return null;
            }
        }, URL::toString));
        DefaultConverterManager.registerConverter(BigInteger.class, StringConverter.of(BigInteger::new, BigInteger::toString));
        DefaultConverterManager.registerConverter(BigDecimal.class, StringConverter.of(BigDecimal::new, BigDecimal::toString));
        DefaultConverterManager.registerConverter(Instant.class, StringConverter.of(Instant::parse, Instant::toString));
    }
}

