/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.morefoworld.core.bukkit.utils;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public final class VersionUtils {
    private static final int MAJOR_VERSION;
    private static final int MINOR_VERSION;
    private static final boolean IS_CRAFTBUKKIT_MAPPED;
    private static final String CRAFTBUKKIT_PACKAGE_VERSION;

    private VersionUtils() {
    }

    public static int getMajorVersion() {
        return MAJOR_VERSION;
    }

    public static int getMinorVersion() {
        return MINOR_VERSION;
    }

    public static boolean isAtLeast(int version) {
        return MAJOR_VERSION >= version;
    }

    public static boolean isAtLeast(int majorVersion, int minorVersion) {
        return MAJOR_VERSION > majorVersion || MAJOR_VERSION == majorVersion && MINOR_VERSION >= minorVersion;
    }

    public static boolean isAt(int majorVersion) {
        return MAJOR_VERSION == majorVersion;
    }

    public static boolean isAt(int majorVersion, int minorVersion) {
        return MAJOR_VERSION == majorVersion && MINOR_VERSION == minorVersion;
    }

    public static boolean isNewerThan(int majorVersion) {
        return MAJOR_VERSION > majorVersion;
    }

    public static boolean isNewerThan(int majorVersion, int minorVersion) {
        return MAJOR_VERSION > majorVersion || MAJOR_VERSION == majorVersion && MINOR_VERSION > minorVersion;
    }

    public static boolean isLowerThan(int majorVersion) {
        return MAJOR_VERSION < majorVersion;
    }

    public static boolean isLowerThan(int majorVersion, int minorVersion) {
        return MAJOR_VERSION < majorVersion || MAJOR_VERSION == majorVersion && MINOR_VERSION < minorVersion;
    }

    public static boolean isCraftBukkitMapped() {
        return IS_CRAFTBUKKIT_MAPPED;
    }

    public static String getCraftBukkitPackageVersion() {
        return CRAFTBUKKIT_PACKAGE_VERSION;
    }

    static {
        Matcher versionMatcher = Pattern.compile("MC: \\d\\.(\\d+)(\\.(\\d+))?").matcher(Bukkit.getVersion());
        if (versionMatcher.find()) {
            MAJOR_VERSION = Integer.parseInt(versionMatcher.group(1));
            MINOR_VERSION = Optional.ofNullable(versionMatcher.group(3)).filter(s -> !s.isEmpty()).map(Integer::parseInt).orElse(0);
        } else {
            MAJOR_VERSION = -1;
            MINOR_VERSION = -1;
        }
        Matcher packageMatcher = Pattern.compile("v\\d+_\\d+_R\\d+").matcher(Bukkit.getServer().getClass().getPackage().getName());
        IS_CRAFTBUKKIT_MAPPED = packageMatcher.find();
        CRAFTBUKKIT_PACKAGE_VERSION = IS_CRAFTBUKKIT_MAPPED ? packageMatcher.group() : "";
    }
}

