/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.morefoworld.config.object;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import me.hsgamer.morefoworld.core.common.Validate;
import org.bukkit.Location;
import org.bukkit.World;

public record Position(double x, double y, double z, float yaw, float pitch) {
    public static Position deserialize(Map<String, Object> map) {
        return new Position(Optional.ofNullable(map.get("x")).map(Object::toString).flatMap(Validate::getNumber).map(BigDecimal::doubleValue).orElse(0.0), Optional.ofNullable(map.get("y")).map(Object::toString).flatMap(Validate::getNumber).map(BigDecimal::doubleValue).orElse(0.0), Optional.ofNullable(map.get("z")).map(Object::toString).flatMap(Validate::getNumber).map(BigDecimal::doubleValue).orElse(0.0), Optional.ofNullable(map.get("yaw")).map(Object::toString).flatMap(Validate::getNumber).map(BigDecimal::floatValue).orElse(Float.valueOf(0.0f)).floatValue(), Optional.ofNullable(map.get("pitch")).map(Object::toString).flatMap(Validate::getNumber).map(BigDecimal::floatValue).orElse(Float.valueOf(0.0f)).floatValue());
    }

    public static Position fromLocation(Location location) {
        return new Position(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public Location toLocation(World world) {
        return new Location(world, this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public Map<String, Object> serialize() {
        return Map.of("x", this.x, "y", this.y, "z", this.z, "yaw", Float.valueOf(this.yaw), "pitch", Float.valueOf(this.pitch));
    }
}

