/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.morefoworld.config;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import me.hsgamer.morefoworld.config.WorldConfigUtil;
import me.hsgamer.morefoworld.config.converter.WorldBiMapConverter;
import me.hsgamer.morefoworld.core.config.annotation.ConfigPath;
import me.hsgamer.morefoworld.core.config.annotation.StickyValue;
import org.bukkit.World;

public interface PortalConfig {
    @ConfigPath(value={"nether"}, converter=WorldBiMapConverter.class)
    @StickyValue
    default public BiMap<String, String> getNetherPortals() {
        return HashBiMap.create();
    }

    public void setNetherPortals(BiMap<String, String> var1);

    default public void linkNetherPortal(String fromWorld, String toWorld) {
        BiMap<String, String> netherPortals = this.getNetherPortals();
        netherPortals.put((Object)fromWorld, (Object)toWorld);
        this.setNetherPortals(netherPortals);
    }

    default public boolean unlinkNetherPortal(String world) {
        BiMap<String, String> netherPortals = this.getNetherPortals();
        if (netherPortals.containsKey((Object)world)) {
            netherPortals.remove((Object)world);
        } else if (netherPortals.containsValue((Object)world)) {
            netherPortals.inverse().remove((Object)world);
        } else {
            return false;
        }
        this.setNetherPortals(netherPortals);
        return true;
    }

    default public Optional<World> getWorldFromNetherPortal(World world) {
        return WorldConfigUtil.getLinkedWorld(world, this.getNetherPortals());
    }

    @ConfigPath(value={"end"}, converter=WorldBiMapConverter.class)
    @StickyValue
    default public BiMap<String, String> getEndPortals() {
        return ImmutableBiMap.of();
    }

    public void setEndPortals(BiMap<String, String> var1);

    default public void linkEndPortal(String fromWorld, String toWorld) {
        BiMap<String, String> endPortals = this.getEndPortals();
        endPortals.put((Object)fromWorld, (Object)toWorld);
        this.setEndPortals(endPortals);
    }

    default public boolean unlinkEndPortal(String world) {
        BiMap<String, String> endPortals = this.getEndPortals();
        if (endPortals.containsKey((Object)world)) {
            endPortals.remove((Object)world);
        } else if (endPortals.containsValue((Object)world)) {
            endPortals.inverse().remove((Object)world);
        } else {
            return false;
        }
        this.setEndPortals(endPortals);
        return true;
    }

    default public Optional<World> getWorldFromEndPortal(World world) {
        return WorldConfigUtil.getLinkedWorld(world, this.getEndPortals());
    }
}

