/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.morefoworld.command.sub;

import java.util.List;
import me.hsgamer.morefoworld.Permissions;
import me.hsgamer.morefoworld.core.bukkit.utils.MessageUtils;
import me.hsgamer.morefoworld.minelib.util.subcommand.SubCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class CurrentCommand
extends SubCommand {
    public CurrentCommand() {
        super("current", "Get the world of the player", "/<label> current [player]", Permissions.CURRENT_WORLD.getName(), true);
    }

    @Override
    public void onSubCommand(@NotNull CommandSender sender, @NotNull String label, String ... args) {
        Player player;
        if (args.length >= 1) {
            player = Bukkit.getPlayer((String)args[0]);
            if (player == null) {
                MessageUtils.sendMessage(sender, "&cThe player is not found");
                return;
            }
            if (player != sender && !sender.hasPermission(Permissions.CURRENT_WORLD_OTHERS.getName())) {
                MessageUtils.sendMessage(sender, "&cYou don't have permission to get the current world of other players");
                return;
            }
        } else if (sender instanceof Player) {
            player = (Player)sender;
        } else {
            MessageUtils.sendMessage(sender, "&cYou must be a player to use this command");
            return;
        }
        MessageUtils.sendMessage(sender, "&aThe current world of &e" + player.getName() + " &a is &e" + player.getWorld().getName());
    }

    @Override
    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull String label, String ... args) {
        if (args.length == 1 && sender.hasPermission(Permissions.TELEPORT_OTHERS)) {
            String arg = args[0].toLowerCase();
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(arg)).toList();
        }
        return super.onTabComplete(sender, label, args);
    }
}

