/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.morefoworld;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.Main;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.CatSpawner;
import net.minecraft.world.entity.npc.wanderingtrader.WanderingTraderSpawner;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.PatrolSpawner;
import net.minecraft.world.level.levelgen.PhantomSpawner;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.validation.ContentValidationException;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.generator.CraftWorldInfo;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;

public final class WorldUtil {
    public static FeedbackWorld addWorld(WorldCreator creator) {
        PrimaryLevelData primaryLevelData;
        Dynamic dataTag;
        LevelStorageSource.LevelStorageAccess levelStorageAccess;
        CraftServer craftServer = (CraftServer)Bukkit.getServer();
        DedicatedServer console = craftServer.getServer();
        String name = creator.name();
        String levelName = console.getProperties().levelName;
        ResourceKey worldKey = null;
        if (name.equals(levelName)) {
            return Feedback.WORLD_DEFAULT.toFeedbackWorld();
        }
        if (name.equals(levelName + "_nether")) {
            if (craftServer.getAllowNether()) {
                return Feedback.WORLD_DEFAULT.toFeedbackWorld();
            }
            worldKey = Level.NETHER;
        } else if (name.equals(levelName + "_the_end")) {
            if (craftServer.getAllowEnd()) {
                return Feedback.WORLD_DEFAULT.toFeedbackWorld();
            }
            worldKey = Level.END;
        }
        ChunkGenerator generator = creator.generator();
        BiomeProvider biomeProvider = creator.biomeProvider();
        File folder = new File(craftServer.getWorldContainer(), name);
        World world = craftServer.getWorld(name);
        CraftWorld worldByKey = (CraftWorld)craftServer.getWorld(creator.key());
        if (world != null || worldByKey != null) {
            return world == worldByKey ? Feedback.WORLD_ALREADY_EXISTS.toFeedbackWorld(worldByKey) : Feedback.WORLD_DUPLICATED.toFeedbackWorld();
        }
        if (folder.exists() && !folder.isDirectory()) {
            return Feedback.WORLD_FOLDER_INVALID.toFeedbackWorld();
        }
        if (generator == null) {
            generator = craftServer.getGenerator(name);
        }
        if (biomeProvider == null) {
            biomeProvider = craftServer.getBiomeProvider(name);
        }
        ResourceKey actualDimension = switch (creator.environment()) {
            case World.Environment.NORMAL -> LevelStem.OVERWORLD;
            case World.Environment.NETHER -> LevelStem.NETHER;
            case World.Environment.THE_END -> LevelStem.END;
            default -> throw new IllegalArgumentException("Illegal dimension");
        };
        try {
            levelStorageAccess = LevelStorageSource.createDefault((Path)craftServer.getWorldContainer().toPath()).validateAndCreateAccess(name, actualDimension);
        }
        catch (IOException | ContentValidationException ex) {
            throw new RuntimeException(ex);
        }
        if (levelStorageAccess.hasWorldData()) {
            LevelSummary summary;
            try {
                dataTag = levelStorageAccess.getDataTag();
                summary = levelStorageAccess.getSummary(dataTag);
            }
            catch (IOException | NbtException | ReportedNbtException ioexception) {
                LevelStorageSource.LevelDirectory convertable_b = levelStorageAccess.getLevelDirectory();
                MinecraftServer.LOGGER.warn("Failed to load world data from {}", (Object)convertable_b.dataFile(), (Object)ioexception);
                MinecraftServer.LOGGER.info("Attempting to use fallback");
                try {
                    dataTag = levelStorageAccess.getDataTagFallback();
                    summary = levelStorageAccess.getSummary(dataTag);
                }
                catch (IOException | NbtException | ReportedNbtException ioexception1) {
                    MinecraftServer.LOGGER.error("Failed to load world data from {}", (Object)convertable_b.oldDataFile(), (Object)ioexception1);
                    MinecraftServer.LOGGER.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)convertable_b.dataFile(), (Object)convertable_b.oldDataFile());
                    return Feedback.WORLD_FOLDER_INVALID.toFeedbackWorld();
                }
                levelStorageAccess.restoreLevelDataFromOld();
            }
            if (summary.requiresManualConversion()) {
                MinecraftServer.LOGGER.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                return Feedback.WORLD_FOLDER_INVALID.toFeedbackWorld();
            }
            if (!summary.isCompatible()) {
                MinecraftServer.LOGGER.info("This world was created by an incompatible version.");
                return Feedback.WORLD_FOLDER_INVALID.toFeedbackWorld();
            }
        } else {
            dataTag = null;
        }
        boolean hardcore = creator.hardcore();
        WorldLoader.DataLoadContext context = console.worldLoaderContext;
        RegistryAccess.Frozen registryAccess = context.datapackDimensions();
        Registry contextLevelStemRegistry = registryAccess.lookupOrThrow(Registries.LEVEL_STEM);
        if (dataTag != null) {
            LevelDataAndDimensions leveldataanddimensions = LevelStorageSource.getLevelDataAndDimensions((Dynamic)dataTag, (WorldDataConfiguration)context.dataConfiguration(), (Registry)contextLevelStemRegistry, (HolderLookup.Provider)context.datapackWorldgen());
            primaryLevelData = (PrimaryLevelData)leveldataanddimensions.worldData();
            registryAccess = leveldataanddimensions.dimensions().dimensionsRegistryAccess();
        } else {
            WorldOptions worldOptions = new WorldOptions(creator.seed(), creator.generateStructures(), false);
            DedicatedServerProperties.WorldDimensionData properties = new DedicatedServerProperties.WorldDimensionData(GsonHelper.parse((String)(creator.generatorSettings().isEmpty() ? "{}" : creator.generatorSettings())), creator.type().name().toLowerCase(Locale.ROOT));
            LevelSettings levelSettings = new LevelSettings(name, WorldUtil.getGameType(GameMode.SURVIVAL), hardcore, Difficulty.EASY, false, new GameRules(context.dataConfiguration().enabledFeatures()), context.dataConfiguration());
            WorldDimensions worldDimensions = properties.create(context.datapackWorldgen());
            WorldDimensions.Complete complete = worldDimensions.bake(contextLevelStemRegistry);
            Lifecycle lifecycle = complete.lifecycle().add(context.datapackWorldgen().allRegistriesLifecycle());
            primaryLevelData = new PrimaryLevelData(levelSettings, worldOptions, complete.specialWorldProperty(), lifecycle);
            registryAccess = complete.dimensionsRegistryAccess();
        }
        primaryLevelData.customDimensions = contextLevelStemRegistry = registryAccess.lookupOrThrow(Registries.LEVEL_STEM);
        primaryLevelData.checkName(name);
        primaryLevelData.setModdedInfo(console.getServerModName(), console.getModdedStatus().shouldReportAsModified());
        long i = BiomeManager.obfuscateSeed((long)primaryLevelData.worldGenOptions().seed());
        ImmutableList list = ImmutableList.of((Object)new PhantomSpawner(), (Object)new PatrolSpawner(), (Object)new CatSpawner(), (Object)new VillageSiege(), (Object)new WanderingTraderSpawner((ServerLevelData)primaryLevelData));
        LevelStem customStem = (LevelStem)contextLevelStemRegistry.getValue(actualDimension);
        CraftWorldInfo worldInfo = new CraftWorldInfo(primaryLevelData, levelStorageAccess, creator.environment(), (DimensionType)customStem.type().value(), customStem.generator(), console.registryAccess());
        if (biomeProvider == null && generator != null) {
            biomeProvider = generator.getDefaultBiomeProvider((WorldInfo)worldInfo);
        }
        if (console.options.has("forceUpgrade")) {
            Main.forceUpgrade((LevelStorageSource.LevelStorageAccess)levelStorageAccess, (WorldData)primaryLevelData, (DataFixer)DataFixers.getDataFixer(), (boolean)console.options.has("eraseCache"), () -> true, (RegistryAccess)registryAccess, (boolean)console.options.has("recreateRegionFiles"));
        }
        if (worldKey == null) {
            worldKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (Identifier)Identifier.fromNamespaceAndPath((String)creator.key().namespace(), (String)creator.key().value()));
        }
        ServerLevel serverLevel = new ServerLevel((MinecraftServer)console, console.executor, levelStorageAccess, primaryLevelData, worldKey, customStem, primaryLevelData.isDebugWorld(), i, (List)(creator.environment() == World.Environment.NORMAL ? list : ImmutableList.of()), true, console.overworld().getRandomSequences(), creator.environment(), generator, biomeProvider);
        console.addLevel(serverLevel);
        console.initWorld(serverLevel, primaryLevelData, primaryLevelData.worldGenOptions());
        serverLevel.setSpawnSettings(true);
        console.prepareLevel(serverLevel);
        return Feedback.SUCCESS.toFeedbackWorld(serverLevel.getWorld());
    }

    public static GameType getGameType(GameMode gameMode) {
        return switch (gameMode) {
            default -> throw new MatchException(null, null);
            case GameMode.SURVIVAL -> GameType.SURVIVAL;
            case GameMode.CREATIVE -> GameType.CREATIVE;
            case GameMode.ADVENTURE -> GameType.ADVENTURE;
            case GameMode.SPECTATOR -> GameType.SPECTATOR;
        };
    }

    public static void applyWorldSpawn(Location location) {
        location.getWorld().setSpawnLocation(location);
    }

    public static enum Feedback {
        WORLD_ALREADY_EXISTS,
        WORLD_DUPLICATED,
        WORLD_FOLDER_INVALID,
        WORLD_DEFAULT,
        SUCCESS;


        public FeedbackWorld toFeedbackWorld(CraftWorld world) {
            return new FeedbackWorld(world, this);
        }

        public FeedbackWorld toFeedbackWorld() {
            return new FeedbackWorld(this);
        }
    }

    public record FeedbackWorld(CraftWorld world, Feedback feedback) {
        public FeedbackWorld(Feedback feedback) {
            this(null, feedback);
        }
    }
}

