/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.morefoworld;

import com.google.common.base.Enums;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import me.hsgamer.morefoworld.core.common.Validate;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;

public class WorldSetting {
    private final String name;
    private long seed = 0L;
    private World.Environment environment = World.Environment.NORMAL;
    private String generator = "";
    private String biomeProvider = "";
    private WorldType type = WorldType.NORMAL;
    private boolean hardcore = false;
    private boolean generateStructures = true;
    private String generatorSettings = "";

    public WorldSetting(String name) {
        this.name = name;
    }

    public static WorldSetting edit(WorldSetting setting, Map<String, Object> map) {
        Optional.ofNullable(map.get("seed")).map(Object::toString).flatMap(Validate::getNumber).map(Number::longValue).ifPresent(setting::setSeed);
        Optional.ofNullable(map.get("environment")).map(Object::toString).flatMap(s -> Enums.getIfPresent(World.Environment.class, (String)s.toUpperCase(Locale.ROOT)).toJavaUtil()).ifPresent(setting::setEnvironment);
        Optional.ofNullable(map.get("generator")).map(Object::toString).ifPresent(setting::setGenerator);
        Optional.ofNullable(map.get("biome-provider")).map(Object::toString).ifPresent(setting::setBiomeProvider);
        Optional.ofNullable(map.get("type")).map(Object::toString).flatMap(s -> Enums.getIfPresent(WorldType.class, (String)s.toUpperCase(Locale.ROOT)).toJavaUtil()).ifPresent(setting::setType);
        Optional.ofNullable(map.get("hardcore")).map(Object::toString).map(Boolean::parseBoolean).ifPresent(setting::setHardcore);
        Optional.ofNullable(map.get("generate-structures")).map(Object::toString).map(Boolean::parseBoolean).ifPresent(setting::setGenerateStructures);
        Optional.ofNullable(map.get("generator-settings")).map(Object::toString).ifPresent(setting::setGeneratorSettings);
        return setting;
    }

    public static WorldSetting fromMap(String name, Map<String, Object> map) {
        return WorldSetting.edit(new WorldSetting(name), map);
    }

    public WorldCreator toWorldCreator() {
        WorldCreator worldCreator = WorldCreator.name((String)this.name);
        if (this.seed != 0L) {
            worldCreator.seed(this.seed);
        }
        worldCreator.environment(this.environment);
        if (!this.generator.isEmpty()) {
            worldCreator.generator(this.generator);
        }
        if (!this.biomeProvider.isEmpty()) {
            worldCreator.biomeProvider(this.biomeProvider);
        }
        worldCreator.type(this.type);
        worldCreator.hardcore(this.hardcore);
        worldCreator.generateStructures(this.generateStructures);
        if (!this.generatorSettings.isEmpty()) {
            worldCreator.generatorSettings(this.generatorSettings);
        }
        return worldCreator;
    }

    public Map<String, Object> toMap() {
        return Map.of("seed", this.seed, "environment", this.environment.name(), "generator", this.generator, "biome-provider", this.biomeProvider, "type", this.type.name(), "hardcore", this.hardcore, "generate-structures", this.generateStructures, "generator-settings", this.generatorSettings);
    }

    public String getName() {
        return this.name;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public World.Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(World.Environment environment) {
        this.environment = environment;
    }

    public String getGenerator() {
        return this.generator;
    }

    public void setGenerator(String generator) {
        this.generator = generator;
    }

    public String getBiomeProvider() {
        return this.biomeProvider;
    }

    public void setBiomeProvider(String biomeProvider) {
        this.biomeProvider = biomeProvider;
    }

    public WorldType getType() {
        return this.type;
    }

    public void setType(WorldType type) {
        this.type = type;
    }

    public boolean isHardcore() {
        return this.hardcore;
    }

    public void setHardcore(boolean hardcore) {
        this.hardcore = hardcore;
    }

    public boolean isGenerateStructures() {
        return this.generateStructures;
    }

    public void setGenerateStructures(boolean generateStructures) {
        this.generateStructures = generateStructures;
    }

    public String getGeneratorSettings() {
        return this.generatorSettings;
    }

    public void setGeneratorSettings(String generatorSettings) {
        this.generatorSettings = generatorSettings;
    }
}

