/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.morefoworld;

import java.util.List;
import java.util.Map;
import me.hsgamer.morefoworld.DebugComponent;
import me.hsgamer.morefoworld.WorldSetting;
import me.hsgamer.morefoworld.WorldUtil;
import me.hsgamer.morefoworld.command.MainCommand;
import me.hsgamer.morefoworld.config.MainConfig;
import me.hsgamer.morefoworld.config.PortalConfig;
import me.hsgamer.morefoworld.config.RespawnConfig;
import me.hsgamer.morefoworld.config.SpawnConfig;
import me.hsgamer.morefoworld.config.WorldSpawnConfig;
import me.hsgamer.morefoworld.config.object.Position;
import me.hsgamer.morefoworld.core.bukkit.config.BukkitConfig;
import me.hsgamer.morefoworld.core.bukkit.utils.MessageUtils;
import me.hsgamer.morefoworld.core.config.proxy.ConfigGenerator;
import me.hsgamer.morefoworld.listener.PortalListener;
import me.hsgamer.morefoworld.listener.RespawnListener;
import me.hsgamer.morefoworld.listener.SpawnListener;
import me.hsgamer.morefoworld.minelib.plugin.base.BasePlugin;
import me.hsgamer.morefoworld.minelib.plugin.command.CommandComponent;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.plugin.Plugin;

public final class MoreFoWorld
extends BasePlugin {
    @Override
    protected List<Object> getComponents() {
        return List.of(ConfigGenerator.newInstance(MainConfig.class, new BukkitConfig((Plugin)this)), ConfigGenerator.newInstance(PortalConfig.class, new BukkitConfig((Plugin)this, "portals.yml")), ConfigGenerator.newInstance(RespawnConfig.class, new BukkitConfig((Plugin)this, "respawn.yml")), ConfigGenerator.newInstance(SpawnConfig.class, new BukkitConfig((Plugin)this, "spawn.yml")), ConfigGenerator.newInstance(WorldSpawnConfig.class, new BukkitConfig((Plugin)this, "world-spawn.yml")), new DebugComponent(this), new PortalListener(this), new RespawnListener(this), new SpawnListener(this), new CommandComponent((BasePlugin)this, () -> List.of(new MainCommand(this))));
    }

    @Override
    public void load() {
        MessageUtils.setPrefix("&8[&6MoreFoWorld&8] &r");
    }

    @Override
    public void enable() {
        for (WorldSetting worldSetting : this.get(MainConfig.class).getWorldSettings()) {
            WorldCreator worldCreator = worldSetting.toWorldCreator();
            WorldUtil.FeedbackWorld feedbackWorld = WorldUtil.addWorld(worldCreator);
            if (feedbackWorld.feedback() == WorldUtil.Feedback.SUCCESS) {
                this.getLogger().info("World " + worldSetting.getName() + " is added");
                continue;
            }
            this.getLogger().warning("World " + worldSetting.getName() + " is not added: " + String.valueOf((Object)feedbackWorld.feedback()));
        }
        for (Map.Entry entry : this.get(WorldSpawnConfig.class).getSpawn().entrySet()) {
            World world = Bukkit.getWorld((String)((String)entry.getKey()));
            if (world == null) {
                return;
            }
            WorldUtil.applyWorldSpawn(((Position)entry.getValue()).toLocation(world));
        }
    }
}

