/*
 * Decompiled with CFR 0.152.
 */
package com.flummidill.simplehomes;

import com.flummidill.libs.json.JSONObject;
import com.flummidill.simplehomes.CommandHandler;
import com.flummidill.simplehomes.HomeManager;
import com.flummidill.simplehomes.JoinListener;
import com.flummidill.simplehomes.TabCompleter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SimpleHomes
extends JavaPlugin {
    private JoinListener joinListener;
    private HomeManager homeManager;

    public void onEnable() {
        this.getLogger().info("~ Created by Flummidill ~");
        this.getLogger().info("Initializing Event Listeners...");
        this.initializeJoinListener();
        this.getLogger().info("Checking for Updates...");
        this.checkForUpdates();
        this.getLogger().info("Initializing Home-Manager...");
        this.homeManager = new HomeManager(this);
        this.getLogger().info("Loading Configuration...");
        this.loadConfig();
        this.getLogger().info("Registering Commands...");
        CommandHandler commandHandler = new CommandHandler(this, this.homeManager);
        TabCompleter tabCompleter = new TabCompleter(this.homeManager);
        this.getCommand("sethome").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("home").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("delhome").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("homeadmin").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("sethome").setTabCompleter((org.bukkit.command.TabCompleter)tabCompleter);
        this.getCommand("home").setTabCompleter((org.bukkit.command.TabCompleter)tabCompleter);
        this.getCommand("delhome").setTabCompleter((org.bukkit.command.TabCompleter)tabCompleter);
        this.getCommand("homeadmin").setTabCompleter((org.bukkit.command.TabCompleter)tabCompleter);
    }

    private void checkForUpdates() {
        String[] latestVersion = this.getLatestVersion().split("\\|", 2);
        String currentVersion = this.getDescription().getVersion();
        if (!"error".equals(latestVersion[0])) {
            if (this.isNewerVersion(latestVersion[0], currentVersion)) {
                this.getLogger().warning("A new Version of SimpleHomes is available: " + latestVersion[0]);
                this.joinListener.setUpdateAvailable(true);
            } else {
                this.getLogger().info("No new Updates available.");
            }
        } else {
            this.getLogger().warning("Failed to Check for Updates!\n" + latestVersion[1]);
        }
    }

    private void loadConfig() {
        int maxHomes = this.getConfig().getInt("max-homes", 3);
        String configVersion = this.getConfig().getString("config-version", "1.0.0");
        String currentVersion = this.getDescription().getVersion();
        this.saveResource("config.yml", true);
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        if (maxHomes < 1 || maxHomes > 50) {
            this.getLogger().warning("Configuration Error: \"max-homes\" was configured incorrectly and reset to \"3\".");
            maxHomes = 3;
        }
        config.set("max-homes", (Object)maxHomes);
        if ("1.0.0".equals(configVersion)) {
            this.getLogger().info("Configuration Update: \"config-version\" has been updated to \"" + currentVersion + "\".");
            this.homeManager.updatePlugin();
            configVersion = currentVersion;
        } else if (this.isNewerVersion(configVersion, "1.0.0")) {
            if (this.isOlderVersion(configVersion, currentVersion)) {
                this.getLogger().info("Configuration Update: \"config-version\" has been updated to \"" + currentVersion + "\".");
                configVersion = currentVersion;
            }
        } else {
            this.getLogger().warning("Configuration Error: \"config-version\" was configured incorrectly and reset to \"" + currentVersion + "\".");
            configVersion = currentVersion;
        }
        config.set("config-version", (Object)configVersion);
        this.saveConfig();
    }

    public String getLatestVersion() {
        String apiUrl = "https://api.github.com/repos/Flummidill/SimpleHomes/releases/latest";
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpResponse<String> response;
            block10: {
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(apiUrl)).header("Accept", "application/json").build();
                try {
                    response = client.send(request, HttpResponse.BodyHandlers.ofString());
                    if (response.statusCode() != 200) break block10;
                    JSONObject json = new JSONObject(response.body());
                    String string = json.getString("tag_name");
                    return string;
                }
                catch (IOException | InterruptedException e) {
                    this.getLogger().warning("Failed to check for Updates!");
                    StringWriter stackTrace = new StringWriter();
                    e.printStackTrace(new PrintWriter(stackTrace));
                    String string = "error|" + String.valueOf(stackTrace);
                    return string;
                }
            }
            String json = "error|java.net.ConnectException: Connection Failed with StatusCode " + response.statusCode() + "\n        at SimpleHomes.jar//com.flummidill.simplehomes.SimpleHomes.getLatestVersion(SimpleHomes.java:77)";
            return json;
        }
    }

    public boolean isNewerVersion(String comparingVersion, String referenceVersion) {
        String[] comparingVersionParts = comparingVersion.split("\\.");
        String[] referenceVersionParts = referenceVersion.split("\\.");
        for (int i = 0; i < 3; ++i) {
            int referenceVersionPart;
            int comparingVersionPart = i < comparingVersionParts.length ? Integer.parseInt(comparingVersionParts[i]) : 0;
            int n = referenceVersionPart = i < referenceVersionParts.length ? Integer.parseInt(referenceVersionParts[i]) : 0;
            if (comparingVersionPart > referenceVersionPart) {
                return true;
            }
            if (comparingVersionPart >= referenceVersionPart) continue;
            return false;
        }
        return false;
    }

    public boolean isOlderVersion(String comparingVersion, String referenceVersion) {
        String[] comparingVersionParts = comparingVersion.split("\\.");
        String[] referenceVersionParts = referenceVersion.split("\\.");
        for (int i = 0; i < 3; ++i) {
            int referenceVersionPart;
            int comparingVersionPart = i < comparingVersionParts.length ? Integer.parseInt(comparingVersionParts[i]) : 0;
            int n = referenceVersionPart = i < referenceVersionParts.length ? Integer.parseInt(referenceVersionParts[i]) : 0;
            if (comparingVersionPart < referenceVersionPart) {
                return true;
            }
            if (comparingVersionPart <= referenceVersionPart) continue;
            return false;
        }
        return false;
    }

    public void initializeJoinListener() {
        this.joinListener = new JoinListener();
        this.getServer().getPluginManager().registerEvents((Listener)this.joinListener, (Plugin)this);
    }
}

