/*
 * Decompiled with CFR 0.152.
 */
package com.flummidill.simplehomes;

import com.flummidill.simplehomes.HomeManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TabCompleter
implements org.bukkit.command.TabCompleter {
    private final HomeManager manager;

    public TabCompleter(HomeManager manager) {
        this.manager = manager;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String cmd;
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player player = (Player)sender;
        UUID uuid = player.getUniqueId();
        switch (cmd = command.getName().toLowerCase()) {
            case "sethome": {
                return this.autocompleteUnsetHomes(uuid, args);
            }
            case "home": {
                return this.autocompleteExistingHomes(uuid, args);
            }
            case "delhome": {
                return this.autocompleteExistingHomes(uuid, args);
            }
            case "homeadmin": {
                return this.autocompleteHomeAdmin(player, args);
            }
        }
        return Collections.emptyList();
    }

    private List<String> autocompleteUnsetHomes(UUID uuid, String[] args) {
        if (args.length == 1) {
            int maxHomes = this.manager.getMaxHomes(uuid);
            Set<Integer> existing = this.manager.getHomeNumbers(uuid);
            ArrayList<String> possible = new ArrayList<String>();
            for (int i = 1; i <= Math.min(maxHomes, 50); ++i) {
                if (existing.contains(i)) continue;
                possible.add(String.valueOf(i));
            }
            return this.filterByPrefix(possible, args[0]);
        }
        return Collections.emptyList();
    }

    private List<String> autocompleteExistingHomes(UUID uuid, String[] args) {
        if (args.length == 1) {
            int maxHomes = this.manager.getMaxHomes(uuid);
            Set<Integer> existing = this.manager.getHomeNumbers(uuid);
            List<String> possible = existing.stream().filter(n -> n >= 1 && n <= Math.min(maxHomes, 50)).map(String::valueOf).sorted().collect(Collectors.toList());
            return this.filterByPrefix(possible, args[0]);
        }
        return Collections.emptyList();
    }

    private List<String> autocompleteHomeAdmin(Player sender, String[] args) {
        if (args.length == 1) {
            List<String> subcommands = Arrays.asList("sethome", "home", "delhome", "maxhomes");
            return this.filterByPrefix(subcommands, args[0]);
        }
        if (args.length == 2) {
            String prefix = args[1].toLowerCase();
            ArrayList<String> playerNames = new ArrayList<String>();
            for (Object p : Bukkit.getOnlinePlayers()) {
                String name2 = p.getName();
                if (playerNames.contains(name2)) continue;
                playerNames.add(name2);
            }
            List<String> offlinePlayerNames = this.manager.getOfflinePlayerNameList();
            for (String name2 : offlinePlayerNames) {
                if (playerNames.contains(name2)) continue;
                playerNames.add(name2);
            }
            return playerNames.stream().filter(name -> name.toLowerCase().startsWith(prefix)).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList());
        }
        if (args.length == 3) {
            String subcommand = args[0].toLowerCase();
            String targetName = args[1];
            Player target = Bukkit.getPlayerExact((String)targetName);
            UUID targetUUID = null;
            if (target != null) {
                targetUUID = target.getUniqueId();
            } else if (this.manager.getOfflinePlayerUUID(targetName) != null) {
                targetUUID = this.manager.getOfflinePlayerUUID(targetName);
            } else {
                return Collections.emptyList();
            }
            if (subcommand.equals("maxhomes")) {
                int maxHomes = this.manager.getMaxHomes(targetUUID);
                return Collections.singletonList(String.valueOf(maxHomes));
            }
            if (Arrays.asList("sethome", "home", "delhome").contains(subcommand)) {
                int maxHomes = this.manager.getMaxHomes(targetUUID);
                Set<Integer> existing = this.manager.getHomeNumbers(targetUUID);
                List<String> possible = new ArrayList<String>();
                if (subcommand.equals("sethome")) {
                    for (int i = 1; i <= Math.min(maxHomes, 50); ++i) {
                        if (existing.contains(i)) continue;
                        possible.add(String.valueOf(i));
                    }
                } else {
                    possible = existing.stream().filter(n -> n >= 1 && n <= Math.min(maxHomes, 50)).map(String::valueOf).sorted().collect(Collectors.toList());
                }
                return this.filterByPrefix(possible, args[2]);
            }
        }
        return Collections.emptyList();
    }

    private List<String> filterByPrefix(List<String> options, String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return options;
        }
        String lower = prefix.toLowerCase();
        return options.stream().filter(s -> s.toLowerCase().startsWith(lower)).limit(50L).collect(Collectors.toList());
    }
}

