/*
 * Decompiled with CFR 0.152.
 */
package com.flummidill.simplehomes;

import com.flummidill.simplehomes.CommandHandler;
import com.flummidill.simplehomes.HomeManager;
import com.flummidill.simplehomes.TabCompleter;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class SimpleHomes
extends JavaPlugin {
    private HomeManager homeManager;

    public void onEnable() {
        this.getLogger().info("~ Created by Flummidill ~");
        this.getLogger().info("Loading Configuration...");
        this.saveDefaultConfig();
        this.validateConfig();
        this.getLogger().info("Initializing Home-Manager...");
        this.homeManager = new HomeManager(this);
        this.getLogger().info("Registering Commands...");
        CommandHandler commandHandler = new CommandHandler(this, this.homeManager);
        TabCompleter tabCompleter = new TabCompleter(this.homeManager);
        this.getCommand("sethome").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("home").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("delhome").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("homeadmin").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("sethome").setTabCompleter((org.bukkit.command.TabCompleter)tabCompleter);
        this.getCommand("home").setTabCompleter((org.bukkit.command.TabCompleter)tabCompleter);
        this.getCommand("delhome").setTabCompleter((org.bukkit.command.TabCompleter)tabCompleter);
        this.getCommand("homeadmin").setTabCompleter((org.bukkit.command.TabCompleter)tabCompleter);
    }

    private void validateConfig() {
        FileConfiguration config = this.getConfig();
        int maxHomes = config.getInt("max-homes", 3);
        if (maxHomes < 1 || maxHomes > 50) {
            this.getLogger().warning("Configuration Error: \"max-homes\" was configured incorrectly and reset to 3.");
            config.set("max-homes", (Object)3);
            this.saveConfig();
        }
    }

    public HomeManager getHomeManager() {
        return this.homeManager;
    }
}

