/*
 * Decompiled with CFR 0.152.
 */
package com.flummidill.simplehomes;

import com.flummidill.simplehomes.SimpleHomes;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class HomeManager {
    private final SimpleHomes plugin;
    private final File dbFile;
    private Connection connection;

    public HomeManager(SimpleHomes plugin) {
        this.plugin = plugin;
        this.dbFile = new File(plugin.getDataFolder(), "homes.db");
        this.openConnection();
        this.createTables();
    }

    private void openConnection() {
        try {
            if (!this.plugin.getDataFolder().exists()) {
                this.plugin.getDataFolder().mkdirs();
            }
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.dbFile.getAbsolutePath());
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Could not connect to SQLite database!");
            e.printStackTrace();
        }
    }

    private void createTables() {
        try (Statement stmt = this.connection.createStatement();){
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS homes (uuid TEXT NOT NULL,home_num INTEGER NOT NULL,world TEXT NOT NULL,x DOUBLE NOT NULL,y DOUBLE NOT NULL,z DOUBLE NOT NULL,pitch DOUBLE NOT NULL,yaw DOUBLE NOT NULL,PRIMARY KEY(uuid, home_num))");
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS home_limits (uuid TEXT NOT NULL,home_limit INTEGER NOT NULL,PRIMARY KEY(uuid))");
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS offline_players (plr_name TEXT NOT NULL,uuid TEXT NOT NULL,PRIMARY KEY(plr_name))");
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to create tables in SQLite database.");
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getMaxHomes(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT home_limit FROM home_limits WHERE uuid = ?");){
            ps.setString(1, uuid.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return this.plugin.getConfig().getInt("max-homes", 3);
            int lim = rs.getInt("home_limit");
            int n = Math.min(Math.max(lim, 1), 50);
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.plugin.getConfig().getInt("max-homes", 3);
    }

    public void setMaxHomes(UUID uuid, int limit) {
        limit = Math.min(Math.max(limit, 1), 50);
        try (PreparedStatement ps = this.connection.prepareStatement("INSERT INTO home_limits(uuid, home_limit) VALUES (?, ?) ON CONFLICT(uuid) DO UPDATE SET home_limit=excluded.home_limit");){
            ps.setString(1, uuid.toString());
            ps.setInt(2, limit);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean homeExists(UUID uuid, int homeNum) {
        boolean bl;
        block8: {
            PreparedStatement ps = this.connection.prepareStatement("SELECT 1 FROM homes WHERE uuid = ? AND home_num = ?");
            try {
                ps.setString(1, uuid.toString());
                ps.setInt(2, homeNum);
                bl = ps.executeQuery().next();
                if (ps == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            ps.close();
        }
        return bl;
    }

    public Set<Integer> getHomeNumbers(UUID uuid) {
        HashSet<Integer> homes = new HashSet<Integer>();
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT home_num FROM homes WHERE uuid = ?");){
            ps.setString(1, uuid.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                homes.add(rs.getInt("home_num"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return homes;
    }

    public void setHome(UUID uuid, int homeNum, Location loc) {
        try (PreparedStatement ps = this.connection.prepareStatement("INSERT INTO homes(uuid, home_num, world, x, y, z, pitch, yaw) VALUES (?, ?, ?, ?, ?, ?, ?, ?) ON CONFLICT(uuid, home_num) DO NOTHING");){
            ps.setString(1, uuid.toString());
            ps.setInt(2, homeNum);
            ps.setString(3, loc.getWorld().getName());
            ps.setDouble(4, Math.floor(loc.getX()) + 0.5);
            ps.setDouble(5, Math.floor(loc.getY()) + 0.5);
            ps.setDouble(6, Math.floor(loc.getZ()) + 0.5);
            double pitch = 0.0;
            double yaw = 0.0;
            if (loc.getYaw() >= 135.0f && loc.getYaw() <= -135.0f) {
                yaw = 180.0;
            } else if (loc.getYaw() < 135.0f && loc.getYaw() > 45.0f) {
                yaw = 90.0;
            } else if (loc.getYaw() <= 45.0f && loc.getYaw() >= -45.0f) {
                yaw = 0.0;
            } else if (loc.getYaw() < -45.0f && loc.getYaw() > -135.0f) {
                yaw = -90.0;
            }
            ps.setDouble(7, pitch);
            ps.setDouble(8, yaw);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteHome(UUID uuid, int homeNum) {
        try (PreparedStatement ps = this.connection.prepareStatement("DELETE FROM homes WHERE uuid = ? AND home_num = ?");){
            ps.setString(1, uuid.toString());
            ps.setInt(2, homeNum);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Location getHome(UUID uuid, int homeNum) {
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT world, x, y, z, yaw, pitch FROM homes WHERE uuid = ? AND home_num = ?");){
            ps.setString(1, uuid.toString());
            ps.setInt(2, homeNum);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return null;
            World world = Bukkit.getWorld((String)rs.getString("world"));
            if (world == null) {
                Location location = null;
                return location;
            }
            Location location = new Location(world, rs.getDouble("x"), rs.getDouble("y"), rs.getDouble("z"), (float)rs.getDouble("yaw"), (float)rs.getDouble("pitch"));
            return location;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void saveOfflinePlayer(String playerName, UUID uuid) {
        try (PreparedStatement ps = this.connection.prepareStatement("INSERT INTO offline_players(plr_name, uuid) VALUES (?, ?) ON CONFLICT(plr_name) DO UPDATE SET uuid=excluded.uuid");){
            ps.setString(1, playerName);
            ps.setString(2, uuid.toString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public List<String> getOfflinePlayerNameList() {
        ArrayList<String> list = new ArrayList<String>();
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT DISTINCT plr_name FROM offline_players");){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String name = rs.getString("plr_name");
                if (name == null) continue;
                list.add(name);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UUID getOfflinePlayerUUID(String playerName) {
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT * FROM offline_players WHERE plr_name = ?");){
            ps.setString(1, playerName);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return null;
            String uuid = rs.getString("uuid");
            if (uuid != null) {
                UUID uUID = UUID.fromString(uuid);
                return uUID;
            }
            UUID uUID = null;
            return uUID;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getOfflinePlayerName(UUID uuid) {
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT * FROM offline_players WHERE uuid = ?");){
            ps.setString(1, uuid.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return null;
            String playerName = rs.getString("plr_name");
            if (playerName != null) {
                String string = playerName;
                return string;
            }
            String string = null;
            return string;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }
}

