/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.schedules;

import fr.florianpal.fauction.FAuction;
import fr.florianpal.fauction.enums.CacheType;
import fr.florianpal.fauction.events.CacheHistoricReloadEvent;
import fr.florianpal.fauction.events.CacheReloadEvent;
import fr.florianpal.fauction.managers.commandmanagers.AuctionCommandManager;
import fr.florianpal.fauction.managers.commandmanagers.ExpireCommandManager;
import fr.florianpal.fauction.managers.commandmanagers.HistoricCommandManager;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class CacheSchedule
implements Runnable {
    private final ExpireCommandManager expireCommandManager;
    private final HistoricCommandManager historicCommandManager;
    private final AuctionCommandManager auctionCommandManager;

    public CacheSchedule(FAuction plugin) {
        this.auctionCommandManager = plugin.getAuctionCommandManager();
        this.historicCommandManager = plugin.getHistoricCommandManager();
        this.expireCommandManager = plugin.getExpireCommandManager();
    }

    @Override
    public void run() {
        FAuction.newChain().async(() -> {
            this.expireCommandManager.updateCache();
            this.historicCommandManager.updateCache();
            this.auctionCommandManager.updateCache();
        }).sync(() -> {
            Bukkit.getPluginManager().callEvent((Event)new CacheReloadEvent(this.expireCommandManager.getCache(), CacheType.EXPIRE));
            Bukkit.getPluginManager().callEvent((Event)new CacheReloadEvent(this.auctionCommandManager.getCache(), CacheType.AUCTION));
            Bukkit.getPluginManager().callEvent((Event)new CacheHistoricReloadEvent(this.historicCommandManager.getCache()));
        }).execute();
    }
}

