/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.configurations;

import dev.dejvokep.boostedyaml.YamlDocument;
import fr.florianpal.fauction.enums.SQLType;

public class DatabaseConfig {
    private SQLType sqlType;
    private String url;
    private String user;
    private String password;
    private int maximumPoolSize;

    public void load(YamlDocument config) {
        this.sqlType = SQLType.valueOf(config.getString("database.type"));
        this.url = config.getString("database.url");
        this.user = config.getString("database.user");
        this.password = config.getString("database.password");
        this.maximumPoolSize = config.getInt("database.maximumPoolSize", (Integer)50);
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public SQLType getSqlType() {
        return this.sqlType;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }
}

