/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.commands;

import fr.florianpal.fauction.FAuction;
import fr.florianpal.fauction.acf.BaseCommand;
import fr.florianpal.fauction.acf.CommandHelp;
import fr.florianpal.fauction.acf.annotation.CommandAlias;
import fr.florianpal.fauction.acf.annotation.CommandPermission;
import fr.florianpal.fauction.acf.annotation.Default;
import fr.florianpal.fauction.acf.annotation.Description;
import fr.florianpal.fauction.acf.annotation.HelpCommand;
import fr.florianpal.fauction.acf.annotation.Subcommand;
import fr.florianpal.fauction.configurations.GlobalConfig;
import fr.florianpal.fauction.events.AuctionAddEvent;
import fr.florianpal.fauction.gui.subGui.AuctionsGui;
import fr.florianpal.fauction.gui.subGui.ExpireGui;
import fr.florianpal.fauction.gui.subGui.HistoricGui;
import fr.florianpal.fauction.gui.subGui.MainGui;
import fr.florianpal.fauction.gui.subGui.PlayerViewGui;
import fr.florianpal.fauction.languages.MessageKeys;
import fr.florianpal.fauction.managers.SpamManager;
import fr.florianpal.fauction.managers.commandmanagers.AuctionCommandManager;
import fr.florianpal.fauction.managers.commandmanagers.ExpireCommandManager;
import fr.florianpal.fauction.managers.commandmanagers.HistoricCommandManager;
import fr.florianpal.fauction.objects.Auction;
import fr.florianpal.fauction.objects.Category;
import fr.florianpal.fauction.utils.FormatUtil;
import fr.florianpal.fauction.utils.ListUtil;
import fr.florianpal.fauction.utils.MessageUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.ShulkerBox;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

@CommandAlias(value="ah|hdv")
public class AuctionCommand
extends BaseCommand {
    private final FAuction plugin;
    private final AuctionCommandManager auctionCommandManager;
    private final ExpireCommandManager expireCommandManager;
    private final HistoricCommandManager historicCommandManager;
    private final SpamManager spamManager;
    private final GlobalConfig globalConfig;
    private List<Integer> itemHash = new ArrayList<Integer>();
    protected DecimalFormat df;

    public AuctionCommand(FAuction plugin) {
        this.plugin = plugin;
        this.auctionCommandManager = plugin.getAuctionCommandManager();
        this.expireCommandManager = plugin.getExpireCommandManager();
        this.spamManager = plugin.getSpamManager();
        this.globalConfig = plugin.getConfigurationManager().getGlobalConfig();
        this.historicCommandManager = plugin.getHistoricCommandManager();
        this.df = new DecimalFormat(plugin.getConfigurationManager().getGlobalConfig().getDecimalFormat());
        this.df.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    }

    @Default
    @Subcommand(value="list")
    @CommandPermission(value="fauction.list")
    @Description(value="{@@fauction.auction_list_help_description}")
    public void onList(Player playerSender) {
        if (this.spamManager.spamTest(playerSender)) {
            return;
        }
        switch (this.globalConfig.getDefaultGui()) {
            case "AUCTION": {
                FAuction.newChain().asyncFirst(this.auctionCommandManager::getAuctions).syncLast(auctions -> {
                    AuctionsGui auctionsGui = new AuctionsGui(this.plugin, playerSender, (List<Auction>)auctions, 1, null, null);
                    auctionsGui.initialize();
                    MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.AUCTION_OPEN, new String[0]);
                }).execute();
                break;
            }
            case "EXPIRE": {
                FAuction.newChain().asyncFirst(() -> this.expireCommandManager.getExpires(playerSender.getUniqueId())).syncLast(expires -> {
                    ExpireGui expireGui = new ExpireGui(this.plugin, playerSender, (List<Auction>)expires, 1, null, null);
                    expireGui.initialize();
                    MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.AUCTION_OPEN, new String[0]);
                }).execute();
                break;
            }
            case "HISTORIC": {
                FAuction.newChain().asyncFirst(() -> this.historicCommandManager.getHistorics(playerSender.getUniqueId())).syncLast(historics -> {
                    HistoricGui historicGui = new HistoricGui(this.plugin, playerSender, ListUtil.historicToAuction(historics), 1, null, null);
                    historicGui.initialize();
                    MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.AUCTION_OPEN, new String[0]);
                }).execute();
                break;
            }
            case "PLAYER": {
                FAuction.newChain().asyncFirst(() -> this.auctionCommandManager.getAuctions(playerSender.getUniqueId())).syncLast(auctions -> {
                    PlayerViewGui playerViewGui = new PlayerViewGui(this.plugin, playerSender, (List<Auction>)auctions, 1, null, null);
                    playerViewGui.initialize();
                    MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.AUCTION_OPEN, new String[0]);
                }).execute();
                break;
            }
            default: {
                String[] id = this.globalConfig.getDefaultGui().split(":");
                if (!"MENU".equals(id[0])) {
                    return;
                }
                MainGui gui = new MainGui(this.plugin, id[1], playerSender, 1);
                gui.initialize();
                MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.AUCTION_OPEN, new String[0]);
            }
        }
    }

    @Subcommand(value="search")
    @CommandPermission(value="fauction.search")
    @Description(value="{@@fauction.auction_search_help_description}")
    public void onSearch(Player playerSender, Material material) {
        if (this.spamManager.spamTest(playerSender)) {
            return;
        }
        if (material.isAir()) {
            MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.SEARCH_AIR, new String[0]);
            return;
        }
        FAuction.newChain().asyncFirst(this.auctionCommandManager::getAuctions).syncLast(auctions -> {
            AuctionsGui auctionsGui = new AuctionsGui(this.plugin, playerSender, (List<Auction>)auctions, 1, new Category("-1", material.name(), List.of(material.toString())), null);
            auctionsGui.initialize();
            MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.AUCTION_OPEN, new String[0]);
        }).execute();
    }

    @Subcommand(value="sell")
    @CommandPermission(value="fauction.sell")
    @Description(value="{@@fauction.auction_add_help_description}")
    public void onAdd(Player playerSender, double priceEntry) {
        ItemStack item;
        ItemMeta itemMeta;
        if (this.spamManager.spamTest(playerSender)) {
            return;
        }
        ItemStack itemToSell = playerSender.getInventory().getItemInMainHand().clone();
        if (this.globalConfig.isFeatureDuplicationHashCodeControl()) {
            if (this.itemHash.contains(itemToSell.hashCode())) {
                return;
            }
            this.itemHash.add(itemToSell.hashCode());
        }
        playerSender.getInventory().getItemInMainHand().setAmount(0);
        double price = this.globalConfig.isFeatureFlippingMoneyFormat() ? Double.parseDouble(this.df.format(priceEntry)) : priceEntry;
        if (price < 0.0) {
            this.resetItem(playerSender, itemToSell);
            MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.NEGATIVE_PRICE, new String[0]);
            return;
        }
        if (itemToSell.getType().equals((Object)Material.AIR)) {
            this.resetItem(playerSender, itemToSell);
            MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.ITEM_AIR, new String[0]);
            return;
        }
        if (this.globalConfig.getBlacklistItem().contains(itemToSell.getType())) {
            this.resetItem(playerSender, itemToSell);
            MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.ITEM_BLACKLIST, new String[0]);
            return;
        }
        if (!this.haveCorrectMinPrice(itemToSell, playerSender, price)) {
            this.resetItem(playerSender, itemToSell);
            return;
        }
        if (!this.haveCorrectMaxPrice(itemToSell, playerSender, price)) {
            this.resetItem(playerSender, itemToSell);
            return;
        }
        if (Tag.SHULKER_BOXES.getValues().contains(itemToSell.getType()) && (itemMeta = (item = playerSender.getInventory().getItemInMainHand()).getItemMeta()) instanceof BlockStateMeta) {
            BlockStateMeta im = (BlockStateMeta)itemMeta;
            double minPrice = -1.0;
            double maxPrice = -1.0;
            ItemStack[] itemStackArray = im.getBlockState();
            if (itemStackArray instanceof ShulkerBox) {
                ShulkerBox shulker = (ShulkerBox)itemStackArray;
                for (ItemStack itemIn : shulker.getInventory().getContents()) {
                    if (itemIn == null || itemIn.getType() == Material.AIR) continue;
                    if (this.plugin.getConfigurationManager().getGlobalConfig().getMinPrice().containsKey(itemIn.getType())) {
                        minPrice += (double)itemIn.getAmount() * this.globalConfig.getMinPrice().get(itemIn.getType());
                    } else if (this.plugin.getConfigurationManager().getGlobalConfig().isDefaultMinValueEnable()) {
                        minPrice += (double)itemIn.getAmount() * this.globalConfig.getDefaultMinValue();
                    }
                    if (this.plugin.getConfigurationManager().getGlobalConfig().getMaxPrice().containsKey(itemIn.getType())) {
                        maxPrice += (double)itemIn.getAmount() * this.globalConfig.getMaxPrice().get(itemIn.getType());
                        continue;
                    }
                    if (!this.plugin.getConfigurationManager().getGlobalConfig().isDefaultMaxValueEnable()) continue;
                    maxPrice += (double)itemIn.getAmount() * this.globalConfig.getDefaultMaxValue();
                }
                if (minPrice != -1.0 && minPrice > price) {
                    MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.MIN_PRICE, "{minPrice}", String.valueOf(Math.ceil(minPrice)));
                    this.resetItem(playerSender, itemToSell);
                    return;
                }
                if (maxPrice != -1.0 && maxPrice < price) {
                    MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.MAX_PRICE, "{maxPrice}", String.valueOf(Math.ceil(maxPrice)));
                    this.resetItem(playerSender, itemToSell);
                    return;
                }
            }
        }
        FAuction.newChain().asyncFirst(() -> this.plugin.getAuctionCommandManager().getAuctions(playerSender.getUniqueId())).syncLast(auctions -> {
            int limitations = this.plugin.getConfigurationManager().getGlobalConfig().isLimitationsUseMetaLuckperms() ? this.plugin.getLimitationManager().getAuctionLimitationByMeta(playerSender) : this.plugin.getLimitationManager().getAuctionLimitationByConfig(playerSender);
            if (limitations != -1 && limitations <= auctions.size()) {
                this.resetItem(playerSender, itemToSell);
                MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.MAX_AUCTION, new String[0]);
                return;
            }
            FAuction.newChain().async(() -> this.auctionCommandManager.addAuction(playerSender, itemToSell, price)).sync(() -> {
                String itemName = itemToSell.getItemMeta().getDisplayName() == null || itemToSell.getItemMeta().getDisplayName().isEmpty() ? itemToSell.getType().toString() : itemToSell.getItemMeta().getDisplayName();
                this.plugin.getLogger().info("Player " + playerSender.getName() + " add item to ah Item : " + itemName + ", At Price : " + price);
                Bukkit.getPluginManager().callEvent((Event)new AuctionAddEvent(playerSender, itemToSell, price));
                MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.AUCTION_ADD_SUCCESS, "{item}", FormatUtil.titleItemFormat(itemToSell), "{price}", String.valueOf(price));
            }).execute();
        }).execute();
    }

    public boolean haveCorrectMinPrice(ItemStack itemToSell, Player player, double price) {
        double minPrice;
        if (this.globalConfig.getMinPrice().containsKey(itemToSell.getType())) {
            double minPrice2 = (double)itemToSell.getAmount() * this.globalConfig.getMinPrice().get(itemToSell.getType());
            if (minPrice2 > price) {
                MessageUtil.sendMessage(this.plugin, player, MessageKeys.MIN_PRICE, "{minPrice}", String.valueOf(Math.ceil(minPrice2)));
                return false;
            }
        } else if (this.globalConfig.isDefaultMinValueEnable() && (minPrice = (double)itemToSell.getAmount() * this.globalConfig.getDefaultMinValue()) > price) {
            MessageUtil.sendMessage(this.plugin, player, MessageKeys.MIN_PRICE, "{minPrice}", String.valueOf(Math.ceil(minPrice)));
            return false;
        }
        return true;
    }

    public void resetItem(Player playerSender, ItemStack item) {
        playerSender.getInventory().setItemInMainHand(item);
        this.itemHash.remove((Object)item.hashCode());
    }

    public boolean haveCorrectMaxPrice(ItemStack itemToSell, Player player, double price) {
        double maxPrice;
        if (this.globalConfig.getMaxPrice().containsKey(itemToSell.getType())) {
            double maxPrice2 = (double)itemToSell.getAmount() * this.globalConfig.getMaxPrice().get(itemToSell.getType());
            if (maxPrice2 < price) {
                MessageUtil.sendMessage(this.plugin, player, MessageKeys.MAX_PRICE, "{maxPrice}", String.valueOf(Math.ceil(maxPrice2)));
                return false;
            }
        } else if (this.globalConfig.isDefaultMaxValueEnable() && (maxPrice = (double)itemToSell.getAmount() * this.globalConfig.getDefaultMaxValue()) < price) {
            MessageUtil.sendMessage(this.plugin, player, MessageKeys.MAX_PRICE, "{maxPrice}", String.valueOf(Math.ceil(maxPrice)));
            return false;
        }
        return true;
    }

    @Subcommand(value="expire")
    @CommandPermission(value="fauction.expire")
    @Description(value="{@@fauction.expire_add_help_description}")
    public void onExpire(Player playerSender) {
        FAuction.newChain().asyncFirst(() -> this.expireCommandManager.getExpires(playerSender.getUniqueId())).syncLast(auctions -> {
            ExpireGui gui = new ExpireGui(this.plugin, playerSender, (List<Auction>)auctions, 1, null, null);
            gui.initialize();
            MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.AUCTION_OPEN, new String[0]);
        }).execute();
    }

    @Subcommand(value="admin reload")
    @CommandPermission(value="fauction.admin.reload")
    @Description(value="{@@fauction.reload_help_description}")
    public void onReload(Player playerSender) {
        this.plugin.reloadConfiguration();
        MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.AUCTION_RELOAD, new String[0]);
    }

    @Subcommand(value="admin purge all")
    @CommandPermission(value="fauction.admin.purge.all")
    @Description(value="{@@fauction.reload_help_description}")
    public void onPurgeAll(Player playerSender) {
        FAuction.newChain().async(() -> {
            this.plugin.purgeAllData();
            MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.AUCTION_PURGE, new String[0]);
        }).execute();
    }

    @Subcommand(value="admin purge historic")
    @CommandPermission(value="fauction.admin.purge.hictoric")
    @Description(value="{@@fauction.reload_help_description}")
    public void onPurgeAllHistoric(Player playerSender) {
        FAuction.newChain().async(() -> {
            this.plugin.purgeAllHistoric();
            MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.AUCTION_PURGE, new String[0]);
        }).execute();
    }

    @Subcommand(value="admin purge expire")
    @CommandPermission(value="fauction.admin.purge.expire")
    @Description(value="{@@fauction.reload_help_description}")
    public void onPurgeAllExpire(Player playerSender) {
        FAuction.newChain().async(() -> {
            this.plugin.purgeAllExpire();
            MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.AUCTION_PURGE, new String[0]);
        }).execute();
    }

    @Subcommand(value="admin purge auction")
    @CommandPermission(value="fauction.admin.purge.auction")
    @Description(value="{@@fauction.reload_help_description}")
    public void onPurgeAllAucton(Player playerSender) {
        FAuction.newChain().async(() -> {
            this.plugin.purgeAllAuction();
            MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.AUCTION_PURGE, new String[0]);
        }).execute();
    }

    @Subcommand(value="admin transfertToPaper")
    @CommandPermission(value="fauction.admin.transfertBddToPaper")
    @Description(value="{@@fauction.transfert_bdd_help_description}")
    public void onTransferBddPaper(Player playerSender) {
        this.plugin.getTransfertManager().transfertBDD(true);
        MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.TRANSFERT_BDD, new String[0]);
    }

    @Subcommand(value="admin transfertToBukkit")
    @CommandPermission(value="fauction.admin.transfertBddToPaper")
    @Description(value="{@@fauction.transfert_bdd_help_description}")
    public void onTransferBddSpigot(Player playerSender) {
        this.plugin.getTransfertManager().transfertBDD(false);
        MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.TRANSFERT_BDD, new String[0]);
    }

    @Subcommand(value="admin migrate")
    @CommandPermission(value="fauction.admin.migrate")
    @Description(value="{@@fauction.migrate_help_description}")
    public void onMigrate(Player playerSender, String migrateVersion) {
        this.plugin.migrate(migrateVersion);
        MessageUtil.sendMessage(this.plugin, playerSender, MessageKeys.MIGRATE, "{version}", migrateVersion);
    }

    @HelpCommand
    @Description(value="{@@fauction.help_description}")
    public void doHelp(CommandSender sender, CommandHelp help) {
        help.showHelp();
    }
}

