/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.taskchain;

import co.aikar.taskchain.AsyncQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class TaskChainAsyncQueue
implements AsyncQueue {
    private static final AtomicInteger threadId = new AtomicInteger();
    private final ThreadPoolExecutor executor;

    public TaskChainAsyncQueue() {
        this.executor = TaskChainAsyncQueue.createCachedThreadPool();
    }

    public TaskChainAsyncQueue(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    public static ThreadPoolExecutor createCachedThreadPool() {
        return (ThreadPoolExecutor)Executors.newCachedThreadPool(r -> {
            Thread thread = new Thread(r);
            thread.setName("TaskChainAsyncQueue Thread " + threadId.getAndIncrement());
            return thread;
        });
    }

    @Override
    public void postAsync(Runnable runnable) {
        this.executor.submit(runnable);
    }

    @Override
    public void shutdown(int timeout, TimeUnit unit) {
        try {
            this.executor.setRejectedExecutionHandler((r, executor1) -> r.run());
            this.executor.shutdown();
            this.executor.awaitTermination(timeout, unit);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

