/*
 * Decompiled with CFR 0.152.
 */
package me.seetch;

import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public final class TranslationKeyGenerator {
    public static String getMaterialKey(Material material) {
        if (material.isBlock()) {
            return "block.minecraft." + material.name().toLowerCase();
        }
        return "item.minecraft." + material.name().toLowerCase();
    }

    public static String getEffectKey(Effect effect) {
        return "effect.minecraft." + effect.name().toLowerCase();
    }

    public static String getEnchantmentKey(Enchantment enchantment) {
        NamespacedKey key = enchantment.getKey();
        if (key.getNamespace().equals("minecraft")) {
            return "enchantment.minecraft." + key.getKey();
        }
        return "enchantment." + key.getNamespace() + "." + key.getKey();
    }

    public static String getEntityKey(EntityType entityType) {
        return "entity.minecraft." + entityType.name().toLowerCase();
    }

    public static String getItemStackKey(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return "block.minecraft.air";
        }
        Material material = itemStack.getType();
        if (material.isBlock()) {
            return "block.minecraft." + material.name().toLowerCase();
        }
        return "item.minecraft." + material.name().toLowerCase();
    }

    public static String getCustomKey(String key) {
        return "mlang." + key.toLowerCase().replace(" ", "_").replace("-", "_");
    }

    private TranslationKeyGenerator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

