/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.schedules;

import fr.florianpal.fauction.FAuction;
import fr.florianpal.fauction.objects.CurrencyPending;
import fr.florianpal.fauction.queries.CurrencyPendingQueries;
import fr.florianpal.fauction.utils.CurrencyUtil;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class CurrencyScheduler
implements Runnable {
    private final CurrencyPendingQueries currencyPendingQueries;
    private final FAuction plugin;

    public CurrencyScheduler(FAuction plugin) {
        this.plugin = plugin;
        this.currencyPendingQueries = plugin.getCurrencyPendingQueries();
    }

    @Override
    public void run() {
        FAuction.newChain().asyncFirst(this.currencyPendingQueries::getCurrencyPending).syncLast(currencyPendings -> {
            for (CurrencyPending currencyPending : currencyPendings) {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)currencyPending.getPlayerUUID());
                if (!offlinePlayer.isOnline()) continue;
                CurrencyUtil.giveCurrency(this.plugin, offlinePlayer, currencyPending.getCurrencyType(), currencyPending.getAmount());
                this.currencyPendingQueries.deleteCurrencyPending(currencyPending.getId());
            }
        }).execute();
    }
}

