/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.managers.commandmanagers;

import fr.florianpal.fauction.FAuction;
import fr.florianpal.fauction.enums.SQLType;
import fr.florianpal.fauction.objects.Auction;
import fr.florianpal.fauction.queries.ExpireQueries;
import fr.florianpal.fauction.utils.SerializationUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class ExpireCommandManager {
    private final ExpireQueries expireQueries;
    private Map<UUID, List<Auction>> cache = new HashMap<UUID, List<Auction>>();
    private List<Auction> sqliteCache = new ArrayList<Auction>();
    private final SQLType sqlType;
    private int idMax = 0;

    public ExpireCommandManager(FAuction plugin) {
        this.expireQueries = plugin.getExpireQueries();
        this.sqliteCache = this.expireQueries.getExpires();
        this.sqlType = plugin.getConfigurationManager().getDatabase().getSqlType();
        if (!this.sqliteCache.isEmpty()) {
            this.idMax = this.sqliteCache.stream().max(Comparator.comparing(Auction::getId)).get().getId() + 1;
        }
        this.updateCache();
    }

    public List<Auction> getExpires() {
        if (SQLType.SQLite.equals((Object)this.sqlType)) {
            return this.sqliteCache;
        }
        return this.expireQueries.getExpires();
    }

    public List<Auction> getExpires(UUID uuid) {
        if (SQLType.SQLite.equals((Object)this.sqlType)) {
            return this.sqliteCache.stream().filter(a -> a.getPlayerUUID().equals(uuid)).collect(Collectors.toList());
        }
        return this.expireQueries.getExpires(uuid);
    }

    public void addExpire(Auction auction) {
        if (SQLType.SQLite.equals((Object)this.sqlType)) {
            this.sqliteCache.add(auction);
            ++this.idMax;
        }
        this.expireQueries.addExpire(auction.getPlayerUUID(), auction.getPlayerName(), SerializationUtil.serialize(auction.getItemStack()), auction.getPrice(), auction.getDate());
    }

    public void deleteExpire(int id) {
        if (SQLType.SQLite.equals((Object)this.sqlType)) {
            this.sqliteCache.removeAll(this.sqliteCache.stream().filter(a -> a.getId() == id).collect(Collectors.toList()));
        }
        this.expireQueries.deleteExpire(id);
    }

    public void deleteAll() {
        if (SQLType.SQLite.equals((Object)this.sqlType)) {
            this.sqliteCache.clear();
        }
        this.expireQueries.deleteAll();
    }

    public Auction expireExist(int id) {
        if (SQLType.SQLite.equals((Object)this.sqlType)) {
            Optional<Auction> auction = this.sqliteCache.stream().filter(a -> a.getId() == id).findFirst();
            return auction.isPresent() ? auction.get() : null;
        }
        return this.expireQueries.getExpire(id);
    }

    public void updateCache() {
        List<Auction> expires = this.expireQueries.getExpires();
        HashMap<UUID, List<Auction>> tempCache = new HashMap<UUID, List<Auction>>();
        for (Auction expire : expires) {
            if (!tempCache.containsKey(expire.getPlayerUUID())) {
                tempCache.put(expire.getPlayerUUID(), new ArrayList());
            }
            ((List)tempCache.get(expire.getPlayerUUID())).add(expire);
        }
        this.cache = tempCache;
    }

    public Map<UUID, List<Auction>> getCache() {
        return this.cache;
    }
}

