/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.managers;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import fr.florianpal.fauction.FAuction;
import fr.florianpal.fauction.enums.SQLType;
import fr.florianpal.fauction.queries.IDatabaseTable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class DatabaseManager {
    private final HikariConfig config = new HikariConfig();
    private final HikariDataSource ds;
    private Connection connection;
    private final FAuction plugin;
    private final ArrayList<IDatabaseTable> repositories = new ArrayList();

    public DatabaseManager(FAuction plugin) throws SQLException {
        this.plugin = plugin;
        this.config.setJdbcUrl(plugin.getConfigurationManager().getDatabase().getUrl());
        this.config.setUsername(plugin.getConfigurationManager().getDatabase().getUser());
        this.config.setPassword(plugin.getConfigurationManager().getDatabase().getPassword());
        this.config.setMaximumPoolSize(plugin.getConfigurationManager().getDatabase().getMaximumPoolSize());
        this.config.addDataSourceProperty("cachePrepStmts", "true");
        this.config.addDataSourceProperty("prepStmtCacheSize", "250");
        this.config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        if (plugin.getConfigurationManager().getDatabase().getSqlType().equals((Object)SQLType.SQLite)) {
            this.config.addDataSourceProperty("dataSource.journal_mode", "WAL");
        }
        if (plugin.getConfigurationManager().getDatabase().getSqlType().equals((Object)SQLType.MariaDB)) {
            this.config.setDriverClassName("org.mariadb.jdbc.Driver");
        }
        this.ds = new HikariDataSource(this.config);
    }

    public void close() {
        this.ds.close();
    }

    public Connection getConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            this.connection = this.ds.getConnection();
        }
        return this.connection;
    }

    public void addRepository(IDatabaseTable repository) {
        this.repositories.add(repository);
    }

    public void initializeTables() {
        try (Connection co = this.getConnection();){
            for (IDatabaseTable repository : this.repositories) {
                String[] tableInformation = repository.getTable();
                if (this.tableExists(co, tableInformation[0])) continue;
                try {
                    Statement statement = co.createStatement();
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS `" + tableInformation[0] + "` (" + tableInformation[1] + ") " + tableInformation[2] + ";");
                    this.plugin.getLogger().info("The table " + tableInformation[0] + " did not exist and was created !");
                }
                catch (SQLException e) {
                    this.plugin.getLogger().severe("Unable to create table " + tableInformation[0] + " !");
                    e.printStackTrace();
                }
            }
            this.plugin.getLogger().info("Initialized database tables");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private boolean tableExists(Connection co, String tableName) throws SQLException {
        DatabaseMetaData dbm = co.getMetaData();
        ResultSet tables = dbm.getTables(null, null, tableName, null);
        return tables.next();
    }
}

