/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.gui.subGui;

import fr.florianpal.fauction.FAuction;
import fr.florianpal.fauction.configurations.gui.PlayerViewConfig;
import fr.florianpal.fauction.enums.CancelReason;
import fr.florianpal.fauction.events.AuctionCancelEvent;
import fr.florianpal.fauction.gui.AbstractGuiWithAuctions;
import fr.florianpal.fauction.gui.subGui.AuctionsGui;
import fr.florianpal.fauction.languages.MessageKeys;
import fr.florianpal.fauction.objects.Auction;
import fr.florianpal.fauction.objects.Category;
import fr.florianpal.fauction.objects.Sort;
import fr.florianpal.fauction.utils.FormatUtil;
import fr.florianpal.fauction.utils.MessageUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerViewGui
extends AbstractGuiWithAuctions {
    private final PlayerViewConfig playerViewConfig;
    private static final Set<Integer> processingAuctions = new HashSet<Integer>();

    public PlayerViewGui(FAuction plugin, Player player, List<Auction> auctions, int page, Category category, Sort sort) {
        super(plugin, player, page, auctions, category, sort, plugin.getConfigurationManager().getPlayerViewConfig());
        this.playerViewConfig = plugin.getConfigurationManager().getPlayerViewConfig();
        this.auctions = auctions.stream().filter(a -> a.getPlayerUUID().equals(player.getUniqueId())).collect(Collectors.toList());
    }

    @Override
    protected void previousAction() {
        FAuction.newChain().asyncFirst(() -> this.auctionCommandManager.getAuctions(this.player.getUniqueId())).syncLast(auctions -> {
            PlayerViewGui gui = new PlayerViewGui(this.plugin, this.player, (List<Auction>)auctions, this.page - 1, this.category, this.sort);
            gui.initialize();
        }).execute();
    }

    @Override
    protected void nextAction() {
        FAuction.newChain().asyncFirst(() -> this.auctionCommandManager.getAuctions(this.player.getUniqueId())).syncLast(auctions -> {
            PlayerViewGui gui = new PlayerViewGui(this.plugin, this.player, (List<Auction>)auctions, this.page + 1, this.category, this.sort);
            gui.initialize();
        }).execute();
    }

    @Override
    protected void categoryAction(Category nextCategory) {
        FAuction.newChain().asyncFirst(() -> this.auctionCommandManager.getAuctions(this.player.getUniqueId())).syncLast(auctions -> {
            PlayerViewGui gui = new PlayerViewGui(this.plugin, this.player, (List<Auction>)auctions, 1, nextCategory, this.sort);
            gui.initialize();
        }).execute();
    }

    @Override
    protected void sortingAction(Sort nextSort) {
        FAuction.newChain().asyncFirst(this.auctionCommandManager::getAuctions).syncLast(auctions -> {
            AuctionsGui gui = new AuctionsGui(this.plugin, this.player, (List<Auction>)auctions, 1, this.category, nextSort);
            gui.initialize();
        }).execute();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getInventory() != this.inv || this.inv.getHolder() != this || this.player != e.getWhoClicked()) {
            return;
        }
        e.setCancelled(true);
        ItemStack clickedItem = e.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        if (this.guiClick(e)) {
            return;
        }
        if (this.spamManager.spamTest(this.player)) {
            return;
        }
        for (Map.Entry<Integer, Integer> index : this.playerViewConfig.getBaseBlocks().entrySet()) {
            if (index.getValue().intValue() != e.getRawSlot()) continue;
            int itemIndex = index.getKey() + 1 + this.playerViewConfig.getBaseBlocks().size() * (this.page - 1) - 1;
            Auction auction = (Auction)this.auctions.get(itemIndex);
            if (!e.isRightClick()) break;
            int auctionId = auction.getId();
            if (processingAuctions.contains(auctionId)) {
                return;
            }
            processingAuctions.add(auctionId);
            FAuction.newChain().asyncFirst(() -> this.auctionCommandManager.auctionExist(auctionId)).abortIfNull().abortIf(a -> !a.getPlayerUUID().equals(this.player.getUniqueId())).syncLast(a -> {
                try {
                    this.auctionCommandManager.deleteAuction(a.getId());
                    if (this.player.getInventory().firstEmpty() == -1) {
                        this.player.getWorld().dropItem(this.player.getLocation(), a.getItemStack());
                    } else {
                        this.player.getInventory().addItem(new ItemStack[]{a.getItemStack()});
                    }
                    this.plugin.getLogger().info("Player delete from ah auction : " + a.getId() + ", Item : " + a.getItemStack().getItemMeta().getDisplayName() + " of " + a.getPlayerName() + ", by" + this.player.getName());
                    this.auctions.remove(a);
                    Bukkit.getPluginManager().callEvent((Event)new AuctionCancelEvent(this.player, (Auction)a, CancelReason.PLAYER));
                    MessageUtil.sendMessage(this.plugin, this.player, MessageKeys.REMOVE_AUCTION_SUCCESS, "{item}", FormatUtil.titleItemFormat(a.getItemStack()));
                }
                catch (Exception exception) {
                    this.plugin.getLogger().severe(exception.toString());
                }
                this.player.closeInventory();
                FAuction.newChain().asyncFirst(this.auctionCommandManager::getAuctions).syncLast(auctions -> {
                    processingAuctions.remove(auctionId);
                    PlayerViewGui gui = new PlayerViewGui(this.plugin, this.player, (List<Auction>)auctions, this.page, this.category, this.sort);
                    gui.initialize();
                }).execute();
            }).abortIfNull().execute(() -> processingAuctions.remove(auctionId));
            break;
        }
    }
}

