/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.gui;

import fr.florianpal.fauction.FAuction;
import fr.florianpal.fauction.configurations.gui.AbstractGuiWithAuctionsConfig;
import fr.florianpal.fauction.gui.AbstractGui;
import fr.florianpal.fauction.objects.Auction;
import fr.florianpal.fauction.objects.Barrier;
import fr.florianpal.fauction.objects.Category;
import fr.florianpal.fauction.objects.Historic;
import fr.florianpal.fauction.objects.Sort;
import fr.florianpal.fauction.utils.FormatUtil;
import fr.florianpal.fauction.utils.ListUtil;
import fr.florianpal.fauction.utils.PlaceholderUtil;
import fr.florianpal.fauction.utils.PlayerHeadUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class AbstractGuiWithAuctions
extends AbstractGui {
    protected List<Auction> auctions;
    protected Category category;
    protected Sort sort;
    protected AbstractGuiWithAuctionsConfig abstractGuiWithAuctionsConfig;

    protected AbstractGuiWithAuctions(FAuction plugin, Player player, int page, List<Auction> auctions, Category category, Sort sort, AbstractGuiWithAuctionsConfig abstractGuiWithAuctionsConfig) {
        super(plugin, player, page, abstractGuiWithAuctionsConfig);
        this.auctions = auctions;
        this.abstractGuiWithAuctionsConfig = abstractGuiWithAuctionsConfig;
        if (category == null) {
            category = plugin.getConfigurationManager().getCategoriesConfig().getDefault();
        }
        if (sort == null) {
            sort = plugin.getConfigurationManager().getSortConfig().getDefault();
        }
        this.category = category;
        this.sort = sort;
        this.auctions = ListUtil.getAuctionByCategory(auctions, category);
        this.auctions = ListUtil.applySorting(this.auctions, sort);
    }

    @Override
    protected void initGui(String title, int size) {
        title = title.replace("{Page}", String.valueOf(this.page));
        title = this.auctions != null && !this.abstractGuiWithAuctionsConfig.getBaseBlocks().isEmpty() ? title.replace("{TotalPage}", String.valueOf((this.auctions.size() - 1) / this.abstractGuiWithAuctionsConfig.getBaseBlocks().size() + 1)) : title.replace("{TotalPage}", "1");
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)this.abstractGuiWithAuctionsConfig.getSize(), (String)FormatUtil.format(title));
    }

    @Override
    protected void initBarrier() {
        for (Barrier previous : this.abstractGuiWithAuctionsConfig.getPreviousBlocks()) {
            if (this.page > 1) {
                this.inv.setItem(previous.getIndex(), this.createGuiItem(this.getItemStack(previous, false)));
                continue;
            }
            this.inv.setItem(previous.getRemplacement().getIndex(), this.createGuiItem(this.getItemStack(previous, true)));
        }
        for (Barrier next : this.abstractGuiWithAuctionsConfig.getNextBlocks()) {
            if (this.abstractGuiWithAuctionsConfig.getBaseBlocks().size() * this.page - this.abstractGuiWithAuctionsConfig.getBaseBlocks().size() < this.auctions.size() - this.abstractGuiWithAuctionsConfig.getBaseBlocks().size()) {
                this.inv.setItem(next.getIndex(), this.createGuiItem(this.getItemStack(next, false)));
                continue;
            }
            this.inv.setItem(next.getRemplacement().getIndex(), this.createGuiItem(this.getItemStack(next, true)));
        }
        for (Barrier categoryBlock : this.abstractGuiWithAuctionsConfig.getCategoriesBlocks()) {
            this.inv.setItem(categoryBlock.getIndex(), this.createGuiItem(this.getItemStack(categoryBlock, false)));
        }
        for (Barrier sortBlock : this.abstractGuiWithAuctionsConfig.getSortingBlocks()) {
            this.inv.setItem(sortBlock.getIndex(), this.createGuiItem(this.getItemStack(sortBlock, false)));
        }
        super.initBarrier();
    }

    @Override
    public void initialize() {
        this.initGui(this.abstractGuiConfig.getNameGui(), this.abstractGuiConfig.getSize());
        this.initBarrier();
        if (!this.auctions.isEmpty()) {
            int id = this.abstractGuiWithAuctionsConfig.getBaseBlocks().size() * this.page - this.abstractGuiWithAuctionsConfig.getBaseBlocks().size();
            for (Map.Entry<Integer, Integer> index : this.abstractGuiWithAuctionsConfig.getBaseBlocks().entrySet()) {
                this.inv.setItem(index.getValue().intValue(), this.createGuiItem(this.auctions.get(id)));
                if (++id < this.auctions.size()) continue;
                break;
            }
        }
        this.openInventory(this.player);
    }

    @Override
    public ItemStack createGuiItem(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null || meta.getDisplayName() == null || meta.getLore() == null) {
            return itemStack;
        }
        String name = FormatUtil.format(meta.getDisplayName());
        ArrayList<String> descriptions = new ArrayList<String>();
        for (String desc : meta.getLore()) {
            desc = this.auctions != null ? desc.replace("{TotalSale}", String.valueOf(this.auctions.size())) : desc.replace("{TotalSale}", "0");
            desc = FormatUtil.format(desc);
            descriptions.add(desc);
        }
        meta.setDisplayName(name);
        meta.setLore(descriptions);
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public ItemStack createGuiItem(Auction auction) {
        OfflinePlayer offlinePlayer;
        ItemStack item = auction.getItemStack().clone();
        ItemMeta meta = item.getItemMeta();
        String title = this.abstractGuiWithAuctionsConfig.getTitle();
        title = FormatUtil.titleItemFormat(item, "{Item}", title);
        title = title.replace("{OwnerName}", auction.getPlayerName());
        title = title.replace("{Price}", this.df.format(auction.getPrice()));
        if (auction instanceof Historic) {
            Historic historic = (Historic)auction;
            title = title.replace("{BuyerName}", historic.getPlayerBuyerName());
            title = title.replace("{BuyDate}", this.dateFormater.format(historic.getBuyDate()));
        }
        if ((offlinePlayer = Bukkit.getOfflinePlayer((UUID)auction.getPlayerUUID())) != null) {
            title = PlaceholderUtil.parsePlaceholder(this.plugin.isPlaceholderAPIEnabled(), offlinePlayer, title);
        }
        title = FormatUtil.format(title);
        ArrayList<String> listDescription = new ArrayList<String>();
        for (String desc : this.abstractGuiWithAuctionsConfig.getDescription()) {
            desc = FormatUtil.titleItemFormat(item, "{Item}", desc);
            desc = desc.replace("{TotalSale}", String.valueOf(this.auctions.size()));
            desc = desc.replace("{OwnerName}", auction.getPlayerName());
            if (auction instanceof Historic) {
                Historic historic = (Historic)auction;
                desc = desc.replace("{BuyerName}", historic.getPlayerBuyerName());
                desc = desc.replace("{BuyDate}", this.dateFormater.format(historic.getBuyDate()));
            }
            if (offlinePlayer != null) {
                desc = PlaceholderUtil.parsePlaceholder(this.plugin.isPlaceholderAPIEnabled(), offlinePlayer, desc);
            }
            desc = desc.replace("{Price}", this.df.format(auction.getPrice()));
            Date expireDate = new Date(auction.getDate().getTime() + (long)this.globalConfig.getTime() * 1000L);
            desc = desc.replace("{ExpireTime}", this.dateFormater.format(expireDate));
            Duration duration = Duration.between(new Date().toInstant(), new Date(auction.getDate().getTime() + (long)this.globalConfig.getTime() * 1000L).toInstant());
            if ((desc = desc.replace("{RemainingTime}", FormatUtil.durationFormat(this.globalConfig.getRemainingDateFormat(), duration))).contains("lore")) {
                if (item.getItemMeta().getLore() != null) {
                    listDescription.addAll(item.getItemMeta().getLore());
                    continue;
                }
                listDescription.add(desc.replace("{lore}", ""));
                continue;
            }
            desc = FormatUtil.format(desc);
            listDescription.add(desc);
        }
        if (meta != null) {
            if (this.abstractGuiWithAuctionsConfig.isReplaceTitle()) {
                meta.setDisplayName(title);
            }
            meta.setLore(listDescription);
            item.setItemMeta(meta);
        }
        return item;
    }

    @Override
    public ItemStack getItemStack(Barrier barrier, boolean isRemplacement) {
        ItemStack itemStack;
        if (isRemplacement) {
            itemStack = this.getItemStack(barrier.getRemplacement(), false);
        } else {
            itemStack = new ItemStack(barrier.getMaterial(), 1);
            if (barrier.getMaterial() == Material.PLAYER_HEAD) {
                PlayerHeadUtil.addTexture(itemStack, barrier.getTexture());
                itemStack.setAmount(1);
            }
            ArrayList<String> descriptions = new ArrayList<String>();
            for (String desc : barrier.getDescription()) {
                desc = FormatUtil.format(desc);
                desc = PlaceholderUtil.parsePlaceholder(this.plugin.isPlaceholderAPIEnabled(), (OfflinePlayer)this.player, desc);
                desc = desc.replace("{categoryDisplayName}", this.category != null ? this.category.getDisplayName() : "");
                desc = desc.replace("{sortDisplayName}", this.category != null ? this.sort.getDisplayName() : "");
                descriptions.add(desc);
            }
            ItemMeta meta = itemStack.getItemMeta();
            if (meta != null) {
                String name = barrier.getTitle().replace("{categoryDisplayName}", this.category != null ? this.category.getDisplayName() : "");
                name = name.replace("{sortDisplayName}", this.category != null ? this.category.getDisplayName() : "");
                name = PlaceholderUtil.parsePlaceholder(this.plugin.isPlaceholderAPIEnabled(), (OfflinePlayer)this.player, name);
                meta.setDisplayName(FormatUtil.format(name));
                meta.setLore(descriptions);
                meta.setCustomModelData(Integer.valueOf(barrier.getCustomModelData()));
                itemStack.setItemMeta(meta);
            }
        }
        return itemStack;
    }

    @Override
    public boolean guiClick(InventoryClickEvent e) {
        boolean isBarrier = this.abstractGuiWithAuctionsConfig.getBarrierBlocks().stream().anyMatch(b -> b.getIndex() == e.getRawSlot());
        if (isBarrier) {
            return true;
        }
        boolean isPrevious = this.abstractGuiWithAuctionsConfig.getPreviousBlocks().stream().anyMatch(b -> b.getIndex() == e.getRawSlot() && this.page > 1);
        if (isPrevious) {
            this.previousAction();
            return true;
        }
        boolean isNext = this.abstractGuiWithAuctionsConfig.getNextBlocks().stream().anyMatch(next -> e.getRawSlot() == next.getIndex() && this.abstractGuiWithAuctionsConfig.getBaseBlocks().size() * this.page - this.abstractGuiWithAuctionsConfig.getBaseBlocks().size() < this.auctions.size() - this.abstractGuiWithAuctionsConfig.getBaseBlocks().size());
        if (isNext) {
            this.nextAction();
            return true;
        }
        boolean isCategory = this.abstractGuiWithAuctionsConfig.getCategoriesBlocks().stream().anyMatch(c -> e.getRawSlot() == c.getIndex());
        if (isCategory) {
            Category nextCategory = this.plugin.getConfigurationManager().getCategoriesConfig().getNext(this.category);
            this.categoryAction(nextCategory);
            return true;
        }
        boolean isSorting = this.abstractGuiWithAuctionsConfig.getSortingBlocks().stream().anyMatch(c -> e.getRawSlot() == c.getIndex());
        if (isSorting) {
            Sort nextSort = this.plugin.getConfigurationManager().getSortConfig().getNext(this.sort);
            this.sortingAction(nextSort);
            return true;
        }
        return super.guiClick(e);
    }

    protected abstract void previousAction();

    protected abstract void nextAction();

    protected abstract void categoryAction(Category var1);

    protected abstract void sortingAction(Sort var1);

    @Override
    public Inventory getInventory() {
        return this.inv;
    }
}

