/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.configurations;

import dev.dejvokep.boostedyaml.YamlDocument;
import fr.florianpal.fauction.objects.Sort;
import java.util.LinkedHashMap;
import java.util.Map;

public class SortConfig {
    private LinkedHashMap<String, Sort> sort;

    public void load(YamlDocument config) {
        this.sort = new LinkedHashMap();
        for (Object id : config.getSection("sort").getKeys()) {
            String displayName = config.getString("sort." + String.valueOf(id) + ".displayName");
            String type = config.getString("sort." + String.valueOf(id) + ".type");
            this.sort.put(id.toString(), new Sort(id.toString(), displayName, type));
        }
    }

    public Map<String, Sort> getSort() {
        return this.sort;
    }

    public Sort getDefault() {
        return this.sort.getOrDefault("DEFAULT", null);
    }

    public Sort getNext(Sort sort) {
        boolean next = false;
        for (Map.Entry<String, Sort> entry : this.sort.entrySet()) {
            if (next) {
                return entry.getValue();
            }
            if (!entry.getKey().equals(sort.getId())) continue;
            next = true;
        }
        return this.getDefault();
    }
}

