/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.configurations;

import dev.dejvokep.boostedyaml.YamlDocument;
import fr.florianpal.fauction.objects.Category;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CategoriesConfig {
    private LinkedHashMap<String, Category> categories;

    public void load(YamlDocument config) {
        this.categories = new LinkedHashMap();
        for (Object id : config.getSection("categories").getKeys()) {
            String displayName = config.getString("categories." + String.valueOf(id) + ".displayName");
            List<String> materials = config.getStringList("categories." + String.valueOf(id) + ".materials");
            this.categories.put(id.toString(), new Category(id.toString(), displayName, materials));
        }
    }

    public Map<String, Category> getCategories() {
        return this.categories;
    }

    public Category getDefault() {
        return this.categories.getOrDefault("default", null);
    }

    public Category getNext(Category category) {
        boolean next = false;
        for (Map.Entry<String, Category> entry : this.categories.entrySet()) {
            if (next) {
                return entry.getValue();
            }
            if (!entry.getKey().equals(category.getId())) continue;
            next = true;
        }
        return this.getDefault();
    }
}

