/*
 * Decompiled with CFR 0.152.
 */
package me.seetch;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import me.seetch.TranslationKeyGenerator;
import me.seetch.libs.gson.Gson;
import me.seetch.libs.gson.JsonObject;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class MLang {
    private static final Logger log = Logger.getLogger(MLang.class.getName());
    private static MLang instance;
    private final JavaPlugin plugin;
    private final Gson gson;
    private final Map<String, JsonObject> loadedLanguages;
    private String defaultLanguage;
    private String defaultVersion;

    private MLang(JavaPlugin plugin) {
        this.plugin = plugin;
        this.gson = new Gson();
        this.loadedLanguages = new HashMap<String, JsonObject>();
        this.defaultLanguage = "en_us";
        this.defaultVersion = this.detectMinecraftVersion();
        File langDir = new File(plugin.getDataFolder(), "languages");
        if (!langDir.exists()) {
            langDir.mkdirs();
        }
    }

    public static synchronized MLang getInstance(JavaPlugin plugin) {
        if (instance == null) {
            instance = new MLang(plugin);
        }
        return instance;
    }

    public void setDefaultLanguage(String languageCode) {
        this.defaultLanguage = languageCode.toLowerCase();
    }

    public void setDefaultVersion(String version) {
        this.defaultVersion = version;
    }

    public CompletableFuture<Boolean> loadLanguageAsync(String languageCode, String version) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.loadLanguage(languageCode, version);
            }
            catch (Exception e) {
                log.severe("Failed to load language " + languageCode + ": " + e.getMessage());
                return false;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadLanguage(String languageCode, String version) {
        languageCode = languageCode.toLowerCase();
        version = version.toLowerCase();
        String fileName = languageCode + ".json";
        File langDir = new File(this.plugin.getDataFolder(), "languages");
        File langFile = new File(langDir, fileName);
        if (this.loadedLanguages.containsKey(languageCode)) {
            return true;
        }
        if (!langFile.exists() && !this.downloadLanguageFile(languageCode, version, langFile)) {
            return false;
        }
        try (FileReader reader = new FileReader(langFile);){
            JsonObject jsonObject = this.gson.fromJson((Reader)reader, JsonObject.class);
            if (jsonObject == null) return false;
            this.loadedLanguages.put(languageCode, jsonObject);
            log.info("Successfully loaded language: " + languageCode);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.severe("Failed to parse language file: " + languageCode + " - " + e.getMessage());
        }
        return false;
    }

    public CompletableFuture<Boolean> loadDefaultLanguageAsync() {
        return this.loadLanguageAsync(this.defaultLanguage, this.defaultVersion);
    }

    private boolean downloadLanguageFile(String languageCode, String version, File saveTo) {
        String baseUrl = "https://raw.githubusercontent.com/InventivetalentDev/minecraft-assets/";
        String fileUrl = baseUrl + version + "/assets/minecraft/lang/" + languageCode + ".json";
        try {
            log.info("Downloading language file: " + languageCode + " (" + version + ")");
            try (BufferedInputStream in = new BufferedInputStream(new URL(fileUrl).openStream());
                 FileOutputStream fileOutputStream = new FileOutputStream(saveTo);){
                int bytesRead;
                byte[] dataBuffer = new byte[1024];
                while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                    fileOutputStream.write(dataBuffer, 0, bytesRead);
                }
            }
            log.info("Successfully downloaded language file: " + languageCode);
            return true;
        }
        catch (Exception e) {
            log.severe("Failed to download language file: " + languageCode + " - " + e.getMessage());
            log.severe("URL: " + fileUrl);
            return false;
        }
    }

    public String getTranslation(String languageCode, String key) {
        JsonObject langJson = this.loadedLanguages.get(languageCode.toLowerCase());
        if (langJson == null || !langJson.has(key)) {
            if (!languageCode.equals(this.defaultLanguage)) {
                return this.getTranslation(this.defaultLanguage, key);
            }
            return key;
        }
        return langJson.get(key).getAsString();
    }

    public String getTranslation(String key) {
        return this.getTranslation(this.defaultLanguage, key);
    }

    public String getMaterialTranslation(String languageCode, Material material) {
        String key = TranslationKeyGenerator.getMaterialKey(material);
        return this.getTranslation(languageCode, key);
    }

    public String getMaterialTranslation(Material material) {
        return this.getMaterialTranslation(this.defaultLanguage, material);
    }

    public String getEffectTranslation(String languageCode, Effect effect) {
        String key = TranslationKeyGenerator.getEffectKey(effect);
        return this.getTranslation(languageCode, key);
    }

    public String getEffectTranslation(Effect effect) {
        return this.getEffectTranslation(this.defaultLanguage, effect);
    }

    public String getEnchantmentTranslation(String languageCode, Enchantment enchantment) {
        String key = TranslationKeyGenerator.getEnchantmentKey(enchantment);
        return this.getTranslation(languageCode, key);
    }

    public String getEnchantmentTranslation(Enchantment enchantment) {
        return this.getEnchantmentTranslation(this.defaultLanguage, enchantment);
    }

    public String getEntityTranslation(String languageCode, EntityType entityType) {
        String key = TranslationKeyGenerator.getEntityKey(entityType);
        return this.getTranslation(languageCode, key);
    }

    public String getEntityTranslation(EntityType entityType) {
        return this.getEntityTranslation(this.defaultLanguage, entityType);
    }

    public String getItemStackTranslation(String languageCode, ItemStack itemStack) {
        String key = TranslationKeyGenerator.getItemStackKey(itemStack);
        return this.getTranslation(languageCode, key);
    }

    public String getItemStackTranslation(ItemStack itemStack) {
        return this.getItemStackTranslation(this.defaultLanguage, itemStack);
    }

    public boolean isLanguageLoaded(String languageCode) {
        return this.loadedLanguages.containsKey(languageCode.toLowerCase());
    }

    public String[] getLoadedLanguages() {
        return this.loadedLanguages.keySet().toArray(new String[0]);
    }

    private String detectMinecraftVersion() {
        try {
            String version = Bukkit.getBukkitVersion();
            if (version.contains("-")) {
                return version.split("-")[0];
            }
            return version;
        }
        catch (Exception e) {
            return "1.20.4";
        }
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public Gson getGson() {
        return this.gson;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }
}

