/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.utils;

import fr.florianpal.fauction.FAuction;
import java.time.Duration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;

public class FormatUtil {
    public static String format(String msg) {
        Pattern pattern = Pattern.compile("#[a-fA-F0-9]{6}");
        Matcher match = pattern.matcher(msg);
        while (match.find()) {
            String color = msg.substring(match.start(), match.end());
            msg = msg.replace(color, String.valueOf(ChatColor.of((String)color)));
            match = pattern.matcher(msg);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
    }

    public static String durationFormat(String format, Duration duration) {
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int seconde = 0;
        if (!duration.isNegative()) {
            long baseSecond = duration.getSeconds();
            year = (int)Math.floor((double)duration.getSeconds() / 3.15576E7);
            month = (int)Math.floor((double)(baseSecond -= (long)year * 31557600L) / 2629800.0);
            day = (int)Math.floor((double)(baseSecond -= (long)month * 2629800L) / 86400.0);
            hour = (int)Math.floor((double)(baseSecond -= (long)day * 86400L) / 3600.0);
            minute = (int)Math.floor((double)(baseSecond -= (long)hour * 3600L) / 60.0);
            seconde = (int)(baseSecond -= (long)minute * 60L);
        }
        format = format.replace("yyyy", "" + year);
        format = format.replace("MM", "" + month);
        format = format.replace("dd", "" + day);
        format = format.replace("HH", "" + hour);
        format = format.replace("mm", "" + minute);
        format = format.replace("ss", "" + seconde);
        return format;
    }

    public static String titleItemFormat(ItemStack item, String replacement, String title) {
        if (item.getItemMeta().getDisplayName().equalsIgnoreCase("")) {
            return title.replace(replacement, FAuction.getApi().getMLang().getItemStackTranslation(item));
        }
        return title.replace(replacement, item.getItemMeta().getDisplayName());
    }

    public static String titleItemFormat(ItemStack item) {
        if (item.getItemMeta().getDisplayName().equalsIgnoreCase("")) {
            return FAuction.getApi().getMLang().getItemStackTranslation(item);
        }
        return item.getItemMeta().getDisplayName();
    }

    public static String formatLanguageCode(String languageCode) {
        if (languageCode.contains("_")) {
            return languageCode;
        }
        return switch (languageCode.toLowerCase()) {
            case "ru" -> "ru_ru";
            case "en" -> "en_us";
            case "fr" -> "fr_fr";
            case "zhcn" -> "zh_cn";
            default -> languageCode + "_" + languageCode;
        };
    }

    public static String formatServerVersion() {
        String bukkitVersion = Bukkit.getServer().getBukkitVersion();
        if (bukkitVersion.contains("-")) {
            return bukkitVersion.split("-")[0];
        }
        return bukkitVersion;
    }
}

