/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.managers.commandmanagers;

import fr.florianpal.fauction.FAuction;
import fr.florianpal.fauction.enums.SQLType;
import fr.florianpal.fauction.objects.Auction;
import fr.florianpal.fauction.queries.AuctionQueries;
import fr.florianpal.fauction.utils.SerializationUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AuctionCommandManager {
    private final AuctionQueries auctionQueries;
    private final Map<UUID, List<Auction>> cache = new HashMap<UUID, List<Auction>>();
    private List<Auction> sqliteCache = new ArrayList<Auction>();
    private final SQLType sqlType;
    private int idMax = 0;

    public AuctionCommandManager(FAuction plugin) {
        this.auctionQueries = plugin.getAuctionQueries();
        this.sqliteCache = this.auctionQueries.getAuctions();
        this.sqlType = plugin.getConfigurationManager().getDatabase().getSqlType();
        if (!this.sqliteCache.isEmpty()) {
            this.idMax = this.sqliteCache.stream().max(Comparator.comparing(Auction::getId)).get().getId() + 1;
        }
        this.updateCache();
    }

    public List<Auction> getAuctions() {
        if (SQLType.SQLite.equals((Object)this.sqlType)) {
            return this.sqliteCache;
        }
        return this.auctionQueries.getAuctions();
    }

    public List<Auction> getAuctions(UUID uuid) {
        if (SQLType.SQLite.equals((Object)this.sqlType)) {
            return this.sqliteCache.stream().filter(a -> a.getPlayerUUID().equals(uuid)).collect(Collectors.toList());
        }
        return this.auctionQueries.getAuctions(uuid);
    }

    public void addAuction(Player player, ItemStack item, double price) {
        if (SQLType.SQLite.equals((Object)this.sqlType)) {
            this.sqliteCache.add(new Auction(this.idMax, player.getUniqueId(), player.getName(), price, SerializationUtil.serialize(item), Calendar.getInstance().getTime().getTime()));
            ++this.idMax;
        }
        this.auctionQueries.addAuction(player.getUniqueId(), player.getName(), SerializationUtil.serialize(item), price, Calendar.getInstance().getTime());
    }

    public void saveAllAuctionInBddFromSQLiteCache() {
        for (Auction auction : this.sqliteCache) {
            this.auctionQueries.addAuction(auction.getPlayerUUID(), auction.getPlayerName(), SerializationUtil.serialize(auction.getItemStack()), auction.getPrice(), auction.getDate());
        }
    }

    public void deleteAuction(int id) {
        if (SQLType.SQLite.equals((Object)this.sqlType)) {
            this.sqliteCache.removeAll(this.sqliteCache.stream().filter(a -> a.getId() == id).collect(Collectors.toList()));
        }
        this.auctionQueries.deleteAuctions(id);
    }

    public void deleteAll() {
        if (SQLType.SQLite.equals((Object)this.sqlType)) {
            this.sqliteCache.clear();
        }
        this.auctionQueries.deleteAll();
    }

    public void deleteAllOnlyOnDB() {
        this.auctionQueries.deleteAll();
    }

    public Auction auctionExist(int id) {
        if (SQLType.SQLite.equals((Object)this.sqlType)) {
            Optional<Auction> auction = this.sqliteCache.stream().filter(a -> a.getId() == id).findFirst();
            return auction.isPresent() ? auction.get() : null;
        }
        return this.auctionQueries.getAuction(id);
    }

    public void updateCache() {
        List<Auction> auctions = this.auctionQueries.getAuctions();
        for (Auction auction : auctions) {
            if (!this.cache.containsKey(auction.getPlayerUUID())) {
                this.cache.put(auction.getPlayerUUID(), new ArrayList());
            }
            this.cache.get(auction.getPlayerUUID()).add(auction);
        }
    }

    public Map<UUID, List<Auction>> getCache() {
        return this.cache;
    }
}

