/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.configurations.gui;

import dev.dejvokep.boostedyaml.YamlDocument;
import fr.florianpal.fauction.FAuction;
import fr.florianpal.fauction.enums.BlockType;
import fr.florianpal.fauction.objects.Barrier;
import fr.florianpal.fauction.objects.BarrierMenu;
import fr.florianpal.fauction.objects.BarrierWithCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryType;

public abstract class AbstractGuiConfig {
    protected InventoryType inventoryType;
    protected String nameGui = "";
    protected int size;
    private List<BarrierWithCategory> auctionGuiBlocks = new ArrayList<BarrierWithCategory>();
    private List<Barrier> closeBlocks = new ArrayList<Barrier>();
    private List<Barrier> commandBlocks = new ArrayList<Barrier>();
    private List<BarrierMenu> menuBlocks = new ArrayList<BarrierMenu>();
    private List<BarrierWithCategory> playerBlocks = new ArrayList<BarrierWithCategory>();
    private List<BarrierWithCategory> historicBlocks = new ArrayList<BarrierWithCategory>();
    private List<Barrier> barrierBlocks = new ArrayList<Barrier>();
    private List<BarrierWithCategory> expireBlocks = new ArrayList<BarrierWithCategory>();

    public void load(FAuction plugin, YamlDocument config, String baseBlock) {
        this.barrierBlocks = new ArrayList<Barrier>();
        this.expireBlocks = new ArrayList<BarrierWithCategory>();
        this.closeBlocks = new ArrayList<Barrier>();
        this.playerBlocks = new ArrayList<BarrierWithCategory>();
        this.historicBlocks = new ArrayList<BarrierWithCategory>();
        this.auctionGuiBlocks = new ArrayList<BarrierWithCategory>();
        this.menuBlocks = new ArrayList<BarrierMenu>();
        this.commandBlocks = new ArrayList<Barrier>();
        this.size = config.getInt("gui.size");
        this.nameGui = config.getString("gui.name");
        this.inventoryType = InventoryType.valueOf((String)config.getString("gui.type", "CHEST"));
        for (Object indexObject : config.getSection("block").getKeys()) {
            Barrier barrier;
            String index = indexObject.toString();
            String currentUtility = config.getString("block." + index + ".utility");
            if (Arrays.stream(BlockType.values()).noneMatch(b -> b.equalsIgnoreCase(currentUtility) || currentUtility.equalsIgnoreCase(baseBlock))) {
                plugin.getLogger().severe("Error : unknown block type " + currentUtility);
                return;
            }
            if (BlockType.PLAYER.equalsIgnoreCase(currentUtility)) {
                barrier = new BarrierWithCategory(Integer.parseInt(index), Material.getMaterial((String)config.getString("block." + index + ".material", Material.BARRIER.toString())), config.getString("block." + index + ".title"), config.getStringList("block." + index + ".description"), config.getString("block." + index + ".texture", ""), config.getInt("block." + index + ".customModelData", (Integer)0), plugin.getConfigurationManager().getCategoriesConfig().getCategories().getOrDefault(config.getString("block." + index + ".category", null), null));
                this.playerBlocks.add((BarrierWithCategory)barrier);
                continue;
            }
            if (BlockType.EXPIREGUI.equalsIgnoreCase(currentUtility)) {
                barrier = new BarrierWithCategory(Integer.parseInt(index), Material.getMaterial((String)config.getString("block." + index + ".material", Material.BARRIER.toString())), config.getString("block." + index + ".title"), config.getStringList("block." + index + ".description"), config.getString("block." + index + ".texture", ""), config.getInt("block." + index + ".customModelData", (Integer)0), plugin.getConfigurationManager().getCategoriesConfig().getCategories().getOrDefault(config.getString("block." + index + ".category", null), null));
                this.expireBlocks.add((BarrierWithCategory)barrier);
                continue;
            }
            if (BlockType.HISTORICGUI.equalsIgnoreCase(currentUtility)) {
                barrier = new BarrierWithCategory(Integer.parseInt(index), Material.getMaterial((String)config.getString("block." + index + ".material", Material.BARRIER.toString())), config.getString("block." + index + ".title"), config.getStringList("block." + index + ".description"), config.getString("block." + index + ".texture", ""), config.getInt("block." + index + ".customModelData", (Integer)0), plugin.getConfigurationManager().getCategoriesConfig().getCategories().getOrDefault(config.getString("block." + index + ".category", null), null));
                this.historicBlocks.add((BarrierWithCategory)barrier);
                continue;
            }
            if (BlockType.BARRIER.equalsIgnoreCase(currentUtility)) {
                barrier = new Barrier(Integer.parseInt(index), Material.getMaterial((String)config.getString("block." + index + ".material", Material.BARRIER.toString())), config.getString("block." + index + ".title"), config.getStringList("block." + index + ".description"), null, config.getString("block." + index + ".texture", ""), config.getInt("block." + index + ".customModelData", (Integer)0));
                this.barrierBlocks.add(barrier);
                continue;
            }
            if (BlockType.CLOSE.equalsIgnoreCase(currentUtility)) {
                barrier = new Barrier(Integer.parseInt(index), Material.getMaterial((String)config.getString("block." + index + ".material", Material.BARRIER.toString())), config.getString("block." + index + ".title"), config.getStringList("block." + index + ".description"), null, config.getString("block." + index + ".texture", ""), config.getInt("block." + index + ".customModelData", (Integer)0));
                this.closeBlocks.add(barrier);
                continue;
            }
            if (BlockType.MENU.equalsIgnoreCase(currentUtility)) {
                barrier = new BarrierMenu(Integer.parseInt(index), Material.getMaterial((String)config.getString("block." + index + ".material", Material.BARRIER.toString())), config.getString("block." + index + ".title"), config.getStringList("block." + index + ".description"), config.getString("block." + index + ".texture", ""), config.getInt("block." + index + ".customModelData", (Integer)0), config.getString("block." + index + ".id", "main"));
                this.menuBlocks.add((BarrierMenu)barrier);
                continue;
            }
            if (BlockType.AUCTIONGUI.equalsIgnoreCase(currentUtility)) {
                barrier = new BarrierWithCategory(Integer.parseInt(index), Material.getMaterial((String)config.getString("block." + index + ".material", Material.BARRIER.toString())), config.getString("block." + index + ".title"), config.getStringList("block." + index + ".description"), config.getString("block." + index + ".texture", ""), config.getInt("block." + index + ".customModelData", (Integer)0), plugin.getConfigurationManager().getCategoriesConfig().getCategories().getOrDefault(config.getString("block." + index + ".category", null), null));
                this.auctionGuiBlocks.add((BarrierWithCategory)barrier);
                continue;
            }
            if (!BlockType.COMMAND.equalsIgnoreCase(currentUtility)) continue;
            barrier = new Barrier(Integer.parseInt(index), Material.getMaterial((String)config.getString("block." + index + ".material", Material.BARRIER.toString())), config.getString("block." + index + ".title"), config.getStringList("block." + index + ".description"), config.getString("block." + index + ".value"), config.getString("block." + index + ".texture", ""), config.getInt("block." + index + ".customModelData", (Integer)0));
            this.commandBlocks.add(barrier);
        }
    }

    public List<BarrierWithCategory> getAuctionGuiBlocks() {
        return this.auctionGuiBlocks;
    }

    public List<Barrier> getCloseBlocks() {
        return this.closeBlocks;
    }

    public List<BarrierWithCategory> getPlayerBlocks() {
        return this.playerBlocks;
    }

    public List<BarrierWithCategory> getHistoricBlocks() {
        return this.historicBlocks;
    }

    public List<Barrier> getBarrierBlocks() {
        return this.barrierBlocks;
    }

    public List<BarrierWithCategory> getExpireBlocks() {
        return this.expireBlocks;
    }

    public List<BarrierMenu> getMenuBlocks() {
        return this.menuBlocks;
    }

    public String getNameGui() {
        return this.nameGui;
    }

    public int getSize() {
        return this.size;
    }

    public InventoryType getType() {
        return this.inventoryType;
    }

    public List<Barrier> getCommandBlocks() {
        return this.commandBlocks;
    }
}

