/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.utils;

import io.papermc.lib.PaperLib;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class SerializationUtil {
    public static byte[] serialize(ItemStack itemStack) throws IllegalStateException {
        if (PaperLib.isPaper()) {
            return itemStack.serializeAsBytes();
        }
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeObject((Object)itemStack);
            dataOutput.close();
            return outputStream.toByteArray();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to save item stacks.", e);
        }
    }

    public static ItemStack deserialize(byte[] data) throws IOException {
        if (PaperLib.isPaper()) {
            return ItemStack.deserializeBytes((byte[])data);
        }
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            ItemStack itemStack = (ItemStack)dataInput.readObject();
            dataInput.close();
            return itemStack;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to decode class type.", e);
        }
    }

    public static byte[] serializeBukkit(ItemStack itemStack) throws IllegalStateException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeObject((Object)itemStack);
            dataOutput.close();
            return outputStream.toByteArray();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to save item stacks.", e);
        }
    }

    public static byte[] serializePaper(ItemStack itemStack) throws IllegalStateException {
        return itemStack.serializeAsBytes();
    }

    public static ItemStack deserializePaper(byte[] data) {
        return ItemStack.deserializeBytes((byte[])data);
    }

    public static ItemStack deserializeBukkit(byte[] data) throws IOException {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            ItemStack itemStack = (ItemStack)dataInput.readObject();
            dataInput.close();
            return itemStack;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to decode class type.", e);
        }
    }
}

