/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.utils;

import java.time.Duration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.inventory.ItemStack;

public class FormatUtil {
    public static String format(String msg) {
        Pattern pattern = Pattern.compile("#[a-fA-F0-9]{6}");
        Matcher match = pattern.matcher(msg);
        while (match.find()) {
            String color = msg.substring(match.start(), match.end());
            msg = msg.replace(color, String.valueOf(ChatColor.of((String)color)));
            match = pattern.matcher(msg);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
    }

    public static String durationFormat(String format, Duration duration) {
        format = format.replace("yyyy", "" + Math.abs(duration.getSeconds() / 31557600L));
        format = format.replace("MM", "" + Math.abs(duration.getSeconds() / 2629800L));
        format = format.replace("dd", "" + Math.abs(duration.getSeconds() / 86400L));
        format = format.replace("HH", "" + Math.abs(duration.getSeconds() / 3600L));
        format = format.replace("mm", "" + Math.abs(duration.getSeconds() % 3600L / 60L));
        format = format.replace("ss", "" + Math.abs(duration.getSeconds() % 60L));
        return format;
    }

    public static String titleItemFormat(ItemStack item, String replacement, String title) {
        if (item.getItemMeta().getDisplayName().equalsIgnoreCase("")) {
            return title.replace(replacement, item.getType().name().replace('_', ' ').toLowerCase());
        }
        return title.replace(replacement, item.getItemMeta().getDisplayName());
    }

    public static String titleItemFormat(ItemStack item) {
        if (item.getItemMeta().getDisplayName().equalsIgnoreCase("")) {
            return item.getType().name().replace('_', ' ').toLowerCase();
        }
        return item.getItemMeta().getDisplayName();
    }
}

