/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.managers.commandmanagers;

import fr.florianpal.fauction.FAuction;
import fr.florianpal.fauction.enums.SQLType;
import fr.florianpal.fauction.objects.Auction;
import fr.florianpal.fauction.objects.Historic;
import fr.florianpal.fauction.queries.HistoricQueries;
import fr.florianpal.fauction.utils.SerializationUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class HistoricCommandManager {
    private final HistoricQueries historicQueries;
    private final Map<UUID, List<Historic>> cache = new HashMap<UUID, List<Historic>>();
    private List<Historic> sqliteCache = new ArrayList<Historic>();
    private final SQLType sqlType;
    private int idMax = 0;

    public HistoricCommandManager(FAuction plugin) {
        this.historicQueries = plugin.getHistoricQueries();
        this.sqliteCache = this.historicQueries.getHistorics();
        this.sqlType = plugin.getConfigurationManager().getDatabase().getSqlType();
        if (!this.sqliteCache.isEmpty()) {
            this.idMax = this.sqliteCache.stream().max(Comparator.comparing(Auction::getId)).get().getId() + 1;
        }
        this.updateCache();
    }

    public List<Historic> getHistorics(UUID uuid) {
        if (SQLType.SQLite.equals((Object)this.sqlType)) {
            return this.sqliteCache.stream().filter(a -> a.getPlayerUUID().equals(uuid)).collect(Collectors.toList());
        }
        return this.historicQueries.getHistorics(uuid);
    }

    public void addHistoric(Auction auction, UUID playerBuyerUUID, String playerBuyerName) {
        if (SQLType.SQLite.equals((Object)this.sqlType)) {
            this.sqliteCache.add(new Historic(this.idMax, auction.getPlayerUUID(), auction.getPlayerName(), playerBuyerUUID, playerBuyerName, auction.getPrice(), SerializationUtil.serialize(auction.getItemStack()), auction.getDate().getTime(), new Date().getTime()));
            ++this.idMax;
        }
        this.historicQueries.addHistoric(auction, playerBuyerUUID, playerBuyerName);
    }

    public void deleteAll() {
        if (SQLType.SQLite.equals((Object)this.sqlType)) {
            this.sqliteCache.clear();
        }
        this.historicQueries.deleteAll();
    }

    public void updateCache() {
        List<Historic> historics = this.historicQueries.getHistorics();
        for (Historic historic : historics) {
            if (!this.cache.containsKey(historic.getPlayerUUID())) {
                this.cache.put(historic.getPlayerUUID(), new ArrayList());
            }
            this.cache.get(historic.getPlayerUUID()).add(historic);
        }
    }

    public Map<UUID, List<Historic>> getCache() {
        return this.cache;
    }
}

