/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.managers;

import fr.florianpal.fauction.FAuction;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultIntegrationManager {
    private Permission perms;
    private Economy economy;

    public VaultIntegrationManager(FAuction plugin) {
        if (plugin.getServer().getPluginManager().getPlugin("Vault") != null) {
            if (!this.setupPermissions()) {
                plugin.getLogger().warning("Failed to initialize Vault Permissions");
            } else {
                plugin.getLogger().info("Registered Vault Permissions");
            }
            if (!this.setupEconomy()) {
                plugin.getLogger().warning("Failed to initialize Vault Economy");
            } else {
                plugin.getLogger().info("Registered Vault Economy");
            }
        } else {
            plugin.getLogger().warning("Vault is not on the server, some features will not work");
        }
    }

    private boolean setupEconomy() {
        RegisteredServiceProvider economyProvider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            this.economy = (Economy)economyProvider.getProvider();
        }
        return this.economy != null;
    }

    private boolean setupPermissions() {
        RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
        if (rsp != null) {
            this.perms = (Permission)rsp.getProvider();
        }
        return this.perms != null;
    }

    public Permission getPerms() {
        return this.perms;
    }

    public Economy getEconomy() {
        return this.economy;
    }
}

