/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.managers;

import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.dvs.versioning.BasicVersioning;
import dev.dejvokep.boostedyaml.settings.dumper.DumperSettings;
import dev.dejvokep.boostedyaml.settings.general.GeneralSettings;
import dev.dejvokep.boostedyaml.settings.loader.LoaderSettings;
import dev.dejvokep.boostedyaml.settings.updater.UpdaterSettings;
import fr.florianpal.fauction.FAuction;
import fr.florianpal.fauction.configurations.CategoriesConfig;
import fr.florianpal.fauction.configurations.DatabaseConfig;
import fr.florianpal.fauction.configurations.GlobalConfig;
import fr.florianpal.fauction.configurations.gui.AuctionConfig;
import fr.florianpal.fauction.configurations.gui.AuctionConfirmGuiConfig;
import fr.florianpal.fauction.configurations.gui.ExpireGuiConfig;
import fr.florianpal.fauction.configurations.gui.HistoricConfig;
import fr.florianpal.fauction.configurations.gui.MenuConfig;
import fr.florianpal.fauction.configurations.gui.PlayerViewConfig;
import java.io.File;
import java.io.IOException;
import java.util.Objects;

public class ConfigurationManager {
    private final DatabaseConfig database = new DatabaseConfig();
    private final YamlDocument databaseConfig;
    private final AuctionConfig auctionConfig = new AuctionConfig();
    private YamlDocument auctionConfiguration;
    private final HistoricConfig historicConfig = new HistoricConfig();
    private YamlDocument historicConfiguration;
    private final PlayerViewConfig playerViewConfig = new PlayerViewConfig();
    private YamlDocument playerViewConfiguration;
    private final ExpireGuiConfig expireConfig = new ExpireGuiConfig();
    private YamlDocument expireConfiguration;
    private final AuctionConfirmGuiConfig auctionConfirmConfig = new AuctionConfirmGuiConfig();
    private YamlDocument auctionConfirmConfiguration;
    private final GlobalConfig globalConfig = new GlobalConfig();
    private YamlDocument globalConfiguration;
    private final CategoriesConfig categoriesConfig = new CategoriesConfig();
    private YamlDocument categoriesConfiguration;
    private final MenuConfig menuConfig = new MenuConfig();

    public ConfigurationManager(FAuction plugin, File pluginFile) {
        try {
            this.databaseConfig = YamlDocument.create(new File(plugin.getDataFolder(), "database.yml"), Objects.requireNonNull(this.getClass().getResourceAsStream("/database.yml")), GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("version")).setOptionSorting(UpdaterSettings.DEFAULT_OPTION_SORTING).build());
        }
        catch (IOException e) {
            plugin.getLogger().severe("Error in database configuration load : " + e.getMessage());
            throw new RuntimeException(e);
        }
        this.database.load(this.databaseConfig);
    }

    public void reload(FAuction plugin) {
        this.loadAllConfiguration(plugin);
    }

    private void loadAllConfiguration(FAuction plugin) {
        try {
            this.auctionConfiguration = YamlDocument.create(new File(plugin.getDataFolder(), "gui/auction.yml"), Objects.requireNonNull(this.getClass().getResourceAsStream("/gui/auction.yml")), GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(false).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("version")).setOptionSorting(UpdaterSettings.DEFAULT_OPTION_SORTING).build());
            this.historicConfiguration = YamlDocument.create(new File(plugin.getDataFolder(), "gui/historic.yml"), Objects.requireNonNull(this.getClass().getResourceAsStream("/gui/historic.yml")), GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(false).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("version")).setOptionSorting(UpdaterSettings.DEFAULT_OPTION_SORTING).build());
            this.playerViewConfiguration = YamlDocument.create(new File(plugin.getDataFolder(), "gui/playerView.yml"), Objects.requireNonNull(this.getClass().getResourceAsStream("/gui/playerView.yml")), GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(false).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("version")).setOptionSorting(UpdaterSettings.DEFAULT_OPTION_SORTING).build());
            this.expireConfiguration = YamlDocument.create(new File(plugin.getDataFolder(), "gui/expire.yml"), Objects.requireNonNull(this.getClass().getResourceAsStream("/gui/expire.yml")), GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(false).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("version")).setOptionSorting(UpdaterSettings.DEFAULT_OPTION_SORTING).build());
            this.auctionConfirmConfiguration = YamlDocument.create(new File(plugin.getDataFolder(), "gui/auctionConfirm.yml"), Objects.requireNonNull(this.getClass().getResourceAsStream("/gui/auctionConfirm.yml")), GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(false).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("version")).setOptionSorting(UpdaterSettings.DEFAULT_OPTION_SORTING).build());
            this.globalConfiguration = YamlDocument.create(new File(plugin.getDataFolder(), "config.yml"), Objects.requireNonNull(this.getClass().getResourceAsStream("/config.yml")), GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("version")).setOptionSorting(UpdaterSettings.DEFAULT_OPTION_SORTING).build());
            this.categoriesConfiguration = YamlDocument.create(new File(plugin.getDataFolder(), "categories.yml"), Objects.requireNonNull(this.getClass().getResourceAsStream("/categories.yml")), GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("version")).setOptionSorting(UpdaterSettings.DEFAULT_OPTION_SORTING).build());
        }
        catch (IOException e) {
            plugin.getLogger().severe("Error in configuration load : " + e.getMessage());
            throw new RuntimeException(e);
        }
        this.categoriesConfig.load(this.categoriesConfiguration);
        this.globalConfig.load(this.globalConfiguration);
        this.auctionConfig.load(plugin, this.auctionConfiguration);
        this.historicConfig.load(plugin, this.historicConfiguration);
        this.auctionConfirmConfig.load(plugin, this.auctionConfirmConfiguration);
        this.expireConfig.load(plugin, this.expireConfiguration);
        this.playerViewConfig.load(plugin, this.playerViewConfiguration);
        File menusDir = new File(plugin.getDataFolder().getPath() + "/gui/menus");
        if (!menusDir.exists()) {
            menusDir.mkdirs();
        }
        this.menuConfig.load(plugin);
    }

    public DatabaseConfig getDatabase() {
        return this.database;
    }

    public AuctionConfig getAuctionConfig() {
        return this.auctionConfig;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public AuctionConfirmGuiConfig getAuctionConfirmConfig() {
        return this.auctionConfirmConfig;
    }

    public ExpireGuiConfig getExpireConfig() {
        return this.expireConfig;
    }

    public PlayerViewConfig getPlayerViewConfig() {
        return this.playerViewConfig;
    }

    public CategoriesConfig getCategoriesConfig() {
        return this.categoriesConfig;
    }

    public HistoricConfig getHistoricConfig() {
        return this.historicConfig;
    }

    public MenuConfig getMenuConfig() {
        return this.menuConfig;
    }
}

