/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.gui.visualization;

import fr.florianpal.fauction.FAuction;
import fr.florianpal.fauction.gui.subGui.AuctionsGui;
import fr.florianpal.fauction.objects.Auction;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.block.Barrel;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public class InventoryVisualization
implements InventoryHolder,
Listener {
    private final FAuction plugin;
    private Inventory inventory;
    private final Player player;

    public InventoryVisualization(FAuction plugin, Player player, ShulkerBox shulkerBox) {
        this.player = player;
        this.plugin = plugin;
        this.createInventory(shulkerBox.getInventory(), InventoryType.SHULKER_BOX);
    }

    public InventoryVisualization(FAuction plugin, Player player, Barrel barrel) {
        this.player = player;
        this.plugin = plugin;
        this.createInventory(barrel.getInventory(), InventoryType.BARREL);
    }

    private void createInventory(Inventory oldInventory, InventoryType inventoryType) {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (InventoryType)inventoryType);
        this.inventory.setContents(oldInventory.getContents());
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInventoryClickEvent(InventoryClickEvent event) {
        if (event.getInventory().getHolder() != this) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
    private void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().getHolder() != this) {
            return;
        }
        FAuction.newChain().asyncFirst(() -> this.plugin.getAuctionCommandManager().getAuctions()).syncLast(auctions -> {
            AuctionsGui gui = new AuctionsGui(this.plugin, this.player, (List<Auction>)auctions, 1, null);
            gui.initialize();
        }).execute();
    }
}

