/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.gui.subGui;

import fr.florianpal.fauction.FAuction;
import fr.florianpal.fauction.gui.AbstractGuiWithAuctions;
import fr.florianpal.fauction.objects.Auction;
import fr.florianpal.fauction.objects.Category;
import fr.florianpal.fauction.utils.ListUtil;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class HistoricGui
extends AbstractGuiWithAuctions {
    public HistoricGui(FAuction plugin, Player player, List<Auction> auctions, int page, Category category) {
        super(plugin, player, page, auctions, category, plugin.getConfigurationManager().getHistoricConfig());
    }

    @Override
    protected void previousAction() {
        FAuction.newChain().asyncFirst(() -> this.historicCommandManager.getHistorics(this.player.getUniqueId())).syncLast(historics -> {
            HistoricGui gui = new HistoricGui(this.plugin, this.player, ListUtil.historicToAuction(historics), this.page - 1, this.category);
            gui.initialize();
        }).execute();
    }

    @Override
    protected void nextAction() {
        FAuction.newChain().asyncFirst(() -> this.historicCommandManager.getHistorics(this.player.getUniqueId())).syncLast(historics -> {
            HistoricGui gui = new HistoricGui(this.plugin, this.player, ListUtil.historicToAuction(historics), this.page + 1, this.category);
            gui.initialize();
        }).execute();
    }

    @Override
    protected void categoryAction(Category nextCategory) {
        FAuction.newChain().asyncFirst(() -> this.historicCommandManager.getHistorics(this.player.getUniqueId())).syncLast(historics -> {
            HistoricGui gui = new HistoricGui(this.plugin, this.player, ListUtil.historicToAuction(historics), 1, nextCategory);
            gui.initialize();
        }).execute();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getInventory() != this.inv || this.inv.getHolder() != this || this.player != e.getWhoClicked()) {
            return;
        }
        e.setCancelled(true);
        ItemStack clickedItem = e.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        this.guiClick(e);
    }
}

