/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.gui.subGui;

import fr.florianpal.fauction.FAuction;
import fr.florianpal.fauction.configurations.gui.ExpireGuiConfig;
import fr.florianpal.fauction.events.ExpireRemoveEvent;
import fr.florianpal.fauction.gui.AbstractGuiWithAuctions;
import fr.florianpal.fauction.languages.MessageKeys;
import fr.florianpal.fauction.objects.Auction;
import fr.florianpal.fauction.objects.Category;
import fr.florianpal.fauction.utils.MessageUtil;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class ExpireGui
extends AbstractGuiWithAuctions {
    private final ExpireGuiConfig expireGuiConfig;

    public ExpireGui(FAuction plugin, Player player, List<Auction> auctions, int page, Category category) {
        super(plugin, player, page, auctions, category, plugin.getConfigurationManager().getExpireConfig());
        this.expireGuiConfig = plugin.getConfigurationManager().getExpireConfig();
    }

    @Override
    protected void previousAction() {
        FAuction.newChain().asyncFirst(this.expireCommandManager::getExpires).syncLast(expires -> {
            ExpireGui gui = new ExpireGui(this.plugin, this.player, (List<Auction>)expires, this.page - 1, this.category);
            gui.initialize();
        }).execute();
    }

    @Override
    protected void nextAction() {
        FAuction.newChain().asyncFirst(this.expireCommandManager::getExpires).syncLast(expires -> {
            ExpireGui gui = new ExpireGui(this.plugin, this.player, (List<Auction>)expires, this.page + 1, this.category);
            gui.initialize();
        }).execute();
    }

    @Override
    protected void categoryAction(Category nextCategory) {
        FAuction.newChain().asyncFirst(this.expireCommandManager::getExpires).syncLast(expires -> {
            ExpireGui gui = new ExpireGui(this.plugin, this.player, this.auctions, 1, nextCategory);
            gui.initialize();
        }).execute();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getInventory() != this.inv || this.inv.getHolder() != this || this.player != e.getWhoClicked()) {
            return;
        }
        e.setCancelled(true);
        ItemStack clickedItem = e.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        if (this.guiClick(e)) {
            return;
        }
        if (this.spamManager.spamTest(this.player)) {
            return;
        }
        for (int index : this.expireGuiConfig.getBaseBlocks()) {
            if (index != e.getRawSlot()) continue;
            if (this.auctions.isEmpty()) {
                this.player.closeInventory();
                return;
            }
            int nb0 = this.expireGuiConfig.getBaseBlocks().get(0);
            int nb = (e.getRawSlot() - nb0) / 9;
            Auction auction = (Auction)this.auctions.get(e.getRawSlot() - nb0 + (this.expireGuiConfig.getExpireBlocks().size() * this.page - this.expireGuiConfig.getExpireBlocks().size()) - nb * 2);
            if (!e.isLeftClick()) continue;
            FAuction.newChain().asyncFirst(() -> this.expireCommandManager.expireExist(auction.getId())).syncLast(a -> {
                if (a == null) {
                    return;
                }
                if (!a.getPlayerUUID().equals(this.player.getUniqueId())) {
                    return;
                }
                if (this.player.getInventory().firstEmpty() == -1) {
                    this.player.getWorld().dropItem(this.player.getLocation(), a.getItemStack());
                } else {
                    this.player.getInventory().addItem(new ItemStack[]{a.getItemStack()});
                }
                this.expireCommandManager.deleteExpire(a.getId());
                this.auctions.remove(a);
                Bukkit.getPluginManager().callEvent((Event)new ExpireRemoveEvent(this.player, (Auction)a));
                MessageUtil.sendMessage(this.plugin, this.player, MessageKeys.REMOVE_EXPIRE_SUCCESS, new String[0]);
                FAuction.newChain().asyncFirst(() -> this.expireCommandManager.getExpires(this.player.getUniqueId())).syncLast(auctions -> {
                    ExpireGui gui = new ExpireGui(this.plugin, this.player, (List<Auction>)auctions, 1, this.category);
                    gui.initialize();
                }).execute();
            }).execute();
        }
    }
}

